/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public class NormalMapFilter {
    public static NormalMapFilter create() {
        return new NormalMapFilter();
    }

    protected NormalMapFilter() {
    }

    public BufferedImage filter(BufferedImage sourceImage, float factor) {
        BufferedImage heightMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        BufferedImage bumpMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ColorConvertOp gscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        gscale.filter(sourceImage, heightMap);
        for (int x = 0; x < bumpMap.getWidth(); ++x) {
            for (int y = 0; y < bumpMap.getHeight(); ++y) {
                bumpMap.setRGB(x, y, this.generateBumpPixel(heightMap, x, y, factor));
            }
        }
        return bumpMap;
    }

    public int generateBumpPixel(BufferedImage image, int x, int y, float a) {
        Vec3f S = new Vec3f();
        Vec3f T = new Vec3f();
        Vec3f N = new Vec3f();
        Vec3f ST = new Vec3f();
        S.x = 1.0f;
        S.y = 0.0f;
        S.z = a * this.getHeight(image, x + 1, y) - a * this.getHeight(image, x - 1, y);
        T.x = 0.0f;
        T.y = 1.0f;
        T.z = a * this.getHeight(image, x, y + 1) - a * this.getHeight(image, x, y - 1);
        float den = (float)Math.sqrt(S.z * S.z + T.z * T.z + 1.0f);
        N.x = -S.z;
        N.y = -T.z;
        N.z = 1.0f;
        N.divideLocal(den);
        return this.vectorToColor(N.x, N.y, N.z);
    }

    private float getHeight(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight() - 1;
        }
        return image.getRGB(x, y) & 0xFF;
    }

    public int vectorToColor(float x, float y, float z) {
        int r = Math.round(255.0f * ((x + 1.0f) / 2.0f));
        int g = Math.round(255.0f * ((y + 1.0f) / 2.0f));
        int b = Math.round(255.0f * ((z + 1.0f) / 2.0f));
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public String toString() {
        return "Bump Map";
    }

    private static class Vec3f {
        float x;
        float y;
        float z;

        private Vec3f() {
        }

        void divideLocal(float d) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
    }
}

