/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.Material;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3dae.utilities.SpatialTreeIterable;

public class ExplicitAnimationNode
extends Node {
    private static final Pattern INT_PATTERN = Pattern.compile("\\d+");
    private final Control animator = new Control(){

        public Control cloneForSpatial(Spatial spatial) {
            return this;
        }

        public void setSpatial(Spatial spatial) {
        }

        public void setEnabled(boolean enabled) {
            ExplicitAnimationNode.this.setEnabled(enabled);
        }

        public boolean isEnabled() {
            return ExplicitAnimationNode.this.isEnabled();
        }

        public void update(float tpf) {
            ExplicitAnimationNode.this.update(tpf);
        }

        public void render(RenderManager rm, ViewPort vp) {
        }

        public void write(JmeExporter ex) throws IOException {
        }

        public void read(JmeImporter im) throws IOException {
        }
    };
    private final Map<String, Mesh[]> sequences = new HashMap<String, Mesh[]>();
    private final Geometry geometry;
    private int currentIndex;
    private Mesh[] currentSequence;
    private boolean enabled;
    private float animationTimeline;
    private float animationFrameTime = 0.5f;
    private float totalAnimationTime;
    private Runnable sequenceEndTask;

    private static String getNamePart(String name) {
        return name.split("\\d+")[0];
    }

    private static Integer getIndexPart(String name) {
        Matcher matcher = INT_PATTERN.matcher(name);
        matcher.find();
        return new Integer(name.substring(matcher.start(), matcher.end()));
    }

    private static boolean isFrameGeometryName(String name) {
        return INT_PATTERN.matcher(name).find();
    }

    private static Mesh[] generateFrameSequence(List<Geometry> frames) {
        HashMap<Integer, Mesh> map = new HashMap<Integer, Mesh>();
        for (Geometry geometry : frames) {
            Integer index = ExplicitAnimationNode.getIndexPart(geometry.getName());
            map.put(index, geometry.getMesh());
        }
        ArrayList list = new ArrayList();
        TreeSet keys = new TreeSet(map.keySet());
        for (Integer integer : keys) {
            list.add(map.get(integer));
        }
        return list.toArray(new Mesh[list.size()]);
    }

    private static Map<String, Mesh[]> generateFrames(Map<String, List<Geometry>> packedGeometries) {
        HashMap<String, Mesh[]> res = new HashMap<String, Mesh[]>();
        for (String string : packedGeometries.keySet()) {
            res.put(string, ExplicitAnimationNode.generateFrameSequence(packedGeometries.get(string)));
        }
        return res;
    }

    private static Map<String, List<Geometry>> packByName(List<Geometry> geometries) {
        HashMap<String, List<Geometry>> res = new HashMap<String, List<Geometry>>();
        for (Geometry geometry : geometries) {
            String name = ExplicitAnimationNode.getNamePart(geometry.getName());
            LinkedList<Geometry> list = (LinkedList<Geometry>)res.get(name);
            if (list == null) {
                list = new LinkedList<Geometry>();
                res.put(name, list);
            }
            list.add(geometry);
        }
        return res;
    }

    private static List<Geometry> extractAllFrames(Node scene) {
        LinkedList<Geometry> frames = new LinkedList<Geometry>();
        for (Spatial s : new SpatialTreeIterable((Spatial)scene)) {
            if (!(s instanceof Geometry) || !ExplicitAnimationNode.isFrameGeometryName(s.getName())) continue;
            frames.add((Geometry)s);
        }
        return frames;
    }

    private static Map<String, Mesh[]> extractAnimations(Node scene, ExplicitAnimationNode ex) {
        List<Geometry> geometries = ExplicitAnimationNode.extractAllFrames(scene);
        ex.setMaterial(geometries.get(0).getMaterial());
        Map<String, List<Geometry>> namedPacks = ExplicitAnimationNode.packByName(geometries);
        return ExplicitAnimationNode.generateFrames(namedPacks);
    }

    private static String createAnimationName(String name) {
        if (name.startsWith("#") && name.length() > 1) {
            name = name.substring(1);
        }
        return name;
    }

    public static ExplicitAnimationNode createFrom(Node animationPack) {
        ExplicitAnimationNode node = new ExplicitAnimationNode("");
        Map<String, Mesh[]> animations = ExplicitAnimationNode.extractAnimations(animationPack, node);
        for (String string : animations.keySet()) {
            String animName = ExplicitAnimationNode.createAnimationName(string);
            node.addSequence(animName, animations.get(string));
        }
        return node;
    }

    public ExplicitAnimationNode(String name) {
        super(name);
        this.geometry = new Geometry(name);
        this.attachChild((Spatial)this.geometry);
        this.addControl(this.animator);
    }

    public void addSequence(String name, Mesh[] meshes) {
        this.sequences.put(name, meshes);
        if (this.currentSequence == null) {
            this.setCurrentSequence(name);
        }
    }

    public Collection<String> getAvailableSequenceNames() {
        return this.sequences.keySet();
    }

    public void setMaterial(Material mat) {
        super.setMaterial(mat);
        this.geometry.setMaterial(mat);
    }

    private void nextFrame() {
        ++this.currentIndex;
        if (this.currentIndex >= this.currentSequence.length) {
            this.currentIndex = 0;
            if (this.sequenceEndTask != null) {
                this.sequenceEndTask.run();
            }
        }
        this.geometry.setMesh(this.currentSequence[this.currentIndex]);
    }

    public void setCurrentSequence(String name) {
        this.currentSequence = this.findSequence(name);
        this.currentIndex = 0;
        if (this.geometry.getMesh() == null) {
            this.geometry.setMesh(this.currentSequence[this.currentIndex]);
            this.geometry.setModelBound((BoundingVolume)new BoundingBox());
            this.geometry.updateModelBound();
            this.setModelBound((BoundingVolume)new BoundingBox());
            this.updateModelBound();
        } else if (this.currentSequence != null) {
            this.geometry.setMesh(this.currentSequence[this.currentIndex]);
        } else {
            System.err.println("Can't play animation " + name);
            return;
        }
        if (this.totalAnimationTime != 0.0f) {
            this.animationFrameTime = this.totalAnimationTime / (float)this.currentSequence.length;
        }
    }

    public void setAnimationFrameTime(float t) {
        this.animationFrameTime = t;
        this.totalAnimationTime = 0.0f;
    }

    public void setAnimationLength(float t) {
        this.totalAnimationTime = t;
        if (this.currentSequence != null) {
            this.animationFrameTime = this.totalAnimationTime / (float)this.currentSequence.length;
        }
    }

    public void setLoopEndNotifiable(Runnable task) {
        this.sequenceEndTask = task;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void update(float tpf) {
        if (this.enabled && this.currentSequence != null) {
            this.animationTimeline += tpf;
            while (this.animationTimeline >= this.animationFrameTime) {
                this.animationTimeline -= this.animationFrameTime;
                this.nextFrame();
            }
        }
    }

    private Mesh[] findSequence(String name) {
        Mesh[] result = this.sequences.get(name);
        if (result == null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Sequence name " + name + " has no match, trying to guess...");
            result = this.guessSequence(name);
        }
        return result;
    }

    private Mesh[] guessSequence(String name) {
        for (String string : this.sequences.keySet()) {
            if (!string.toLowerCase().contains(name.toLowerCase())) continue;
            return this.sequences.get(string);
        }
        return null;
    }
}

