/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Conditions {
    private static final Conditions INSTANCE = new Conditions();

    private Conditions() {
    }

    public static void checkNotNull(Object value) throws CheckException {
        if (value == null) {
            Conditions.signalError("Expected not null value.");
        }
    }

    public static void checkTrue(boolean expr) throws CheckException {
        if (!expr) {
            Conditions.signalError("expected true");
        }
    }

    public static void checkValue(int value, int expected) throws CheckException {
        if (value != expected) {
            Conditions.signalError("Expected " + expected + " got " + value);
        }
    }

    public static void checkTrue(boolean expr, String errorMessage) throws CheckException {
        if (!expr) {
            Conditions.signalError(errorMessage);
        }
    }

    public static void checkFalse(boolean expr, String errorMessage) throws CheckException {
        if (expr) {
            Conditions.signalError(errorMessage);
        }
    }

    private static void signalError(String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "";
        }
        String log = "Condition failure";
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 3) {
            log = log + "\nAt: " + stack[3];
        }
        Logger.getLogger(Conditions.class.getName()).log(Level.SEVERE, log);
        if (errorMessage == null) {
            errorMessage = "";
        }
        throw new CheckException(errorMessage);
    }

    public static class CheckException
    extends RuntimeException {
        public CheckException(String message) {
            super(message);
        }
    }
}

