/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.materials;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.utilities.NormalMapFilter;
import jme3tools.converters.ImageToAwt;

public class FXBumpMaterialGenerator {
    private static final Map<Texture, Texture> NORMAL_MAPS = new ConcurrentHashMap<Texture, Texture>();
    private final AssetManager ASSET_MANAGER;
    private final Material MATERIAL;
    private final boolean autobump;
    private boolean hasTexture = false;

    public static FXBumpMaterialGenerator create(AssetManager am, boolean autobump) {
        return new FXBumpMaterialGenerator(am, autobump);
    }

    private FXBumpMaterialGenerator(AssetManager am, boolean autobump) {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Generating Normal Maps? " + autobump);
        this.ASSET_MANAGER = am;
        this.autobump = autobump;
        this.MATERIAL = new Material(am, "Common/MatDefs/Light/Lighting.j3md");
        this.MATERIAL.setFloat("Shininess", 8.0f);
    }

    public void setTexture(Texture texture) {
        if (texture != null) {
            this.MATERIAL.setTexture("DiffuseMap", texture);
            if (this.autobump) {
                this.MATERIAL.setTexture("NormalMap", this.getNormalMap(texture));
            }
            this.MATERIAL.setBoolean("UseMaterialColors", false);
            this.hasTexture = true;
        }
    }

    public void setAmbient(ColorRGBA color) {
        if (!this.autobump && color != null) {
            this.MATERIAL.setBoolean("UseMaterialColors", true);
            this.MATERIAL.setColor("Ambient", color);
        }
    }

    public void setDiffuse(ColorRGBA color) {
        if (!this.autobump && color != null) {
            this.MATERIAL.setBoolean("UseMaterialColors", true);
            this.MATERIAL.setColor("Diffuse", color);
        }
    }

    public void setShininess(Float value) {
        if (value != null) {
            this.MATERIAL.setFloat("Shininess", value);
        }
    }

    public Material get() {
        return this.MATERIAL.clone();
    }

    private Texture getNormalMap(Texture texture) {
        Texture nmap = NORMAL_MAPS.get(texture);
        if (nmap == null) {
            nmap = this.generateNormalMap(texture);
            NORMAL_MAPS.put(texture, nmap);
        }
        return nmap;
    }

    private Texture generateNormalMap(Texture texture) {
        BufferedImage image = ImageToAwt.convert((Image)texture.getImage(), (boolean)false, (boolean)false, (int)0);
        BufferedImage normal = NormalMapFilter.create().filter(image, 0.01f);
        Image jme = new AWTLoader().load(normal, false);
        Texture2D jmeTexture = new Texture2D(jme);
        jmeTexture.setWrap(Texture.WrapAxis.S, texture.getWrap(Texture.WrapAxis.S));
        jmeTexture.setWrap(Texture.WrapAxis.T, texture.getWrap(Texture.WrapAxis.T));
        jmeTexture.setMagFilter(texture.getMagFilter());
        jmeTexture.setMinFilter(texture.getMinFilter());
        return jmeTexture;
    }
}

