/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.collada14.transformers.GeometryTransformer;
import jme3dae.collada14.transformers.InputShared;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.MeasuringUnit;
import jme3dae.utilities.PolygonArrayTransformer;
import jme3dae.utilities.Todo;
import jme3dae.utilities.Tuple2;

public class PolylistTransformer
extends GeometryTransformer<Tuple2<DAENode, Bindings>, Geometry> {
    public static PolylistTransformer create() {
        return new PolylistTransformer();
    }

    private PolylistTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Geometry> transform(Tuple2<DAENode, Bindings> value) {
        Geometry geom = null;
        DAENode poly = value.getA();
        Bindings bindings = value.getB();
        Tuple2<Integer, List<InputShared>> inputData = this.getInputs(poly);
        List<InputShared> inputs = inputData.getB();
        int chunkSize = inputData.getA();
        PolygonData[] polygons = new PolygonData[poly.getAttribute("count", INTEGER).get().intValue()];
        ValueTransformer.TransformedValue<int[]> vcount = poly.getChild("vcount").getContent(INTEGER_LIST);
        if (vcount.isDefined()) {
            int[] vc = vcount.get();
            for (int i = 0; i < vc.length; ++i) {
                polygons[i] = PolygonData.create(vc[i]);
            }
            ValueTransformer.TransformedValue<int[]> pvalues = poly.getChild("p").getContent(INTEGER_LIST);
            if (pvalues.isDefined()) {
                int[] p = pvalues.get();
                for (InputShared inputShared : inputs) {
                    inputShared.transferData(chunkSize, p, polygons);
                }
                MeasuringUnit unit = poly.getRootNode().getParsedData(MeasuringUnit.class);
                ValueTransformer.TransformedValue<Tuple2<Mesh, PolygonData[]>> mesh = PolygonArrayTransformer.create().transform(Tuple2.create(unit, polygons));
                if (mesh.isDefined()) {
                    poly.setParsedData(mesh.get().getB());
                    poly.setParsedData(mesh.get().getA());
                    geom = new Geometry("model");
                    geom.setMesh(mesh.get().getA());
                    geom.setModelBound((BoundingVolume)new BoundingBox());
                    geom.updateModelBound();
                    this.applyMaterial(geom, poly, bindings);
                } else {
                    Todo.task("cannot generate mesh... why");
                }
            } else {
                Todo.task("polylist has no p data");
            }
        } else {
            Todo.task("polylist element has no vcount data.");
        }
        return ValueTransformer.TransformedValue.create(geom);
    }
}

