/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.collada14.transformers.GeometryTransformer;
import jme3dae.collada14.transformers.InputShared;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.MeasuringUnit;
import jme3dae.utilities.PolygonArrayTransformer;
import jme3dae.utilities.Todo;
import jme3dae.utilities.Tuple2;

public class PolygonsTransformer
extends GeometryTransformer<Tuple2<DAENode, Bindings>, Geometry> {
    public static PolygonsTransformer create() {
        return new PolygonsTransformer();
    }

    private PolygonsTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Geometry> transform(Tuple2<DAENode, Bindings> value) {
        Geometry geom = null;
        DAENode polys = value.getA();
        Bindings bindings = value.getB();
        Tuple2<Integer, List<InputShared>> inputData = super.getInputs(polys);
        int chunkSize = inputData.getA();
        List<InputShared> inputs = inputData.getB();
        PolygonData[] polygons = new PolygonData[polys.getAttribute("count", INTEGER).get().intValue()];
        int polyIndex = 0;
        int[] pvalues = new int[]{};
        for (DAENode pNode : polys.getChildren("p")) {
            int[] indices = pNode.getContent(INTEGER_LIST).get();
            int vertexCount = indices.length / chunkSize;
            polygons[polyIndex] = PolygonData.create(vertexCount);
            ++polyIndex;
            pvalues = super.merge(pvalues, indices);
        }
        for (InputShared inputShared : inputs) {
            inputShared.transferData(chunkSize, pvalues, polygons);
        }
        MeasuringUnit unit = polys.getRootNode().getParsedData(MeasuringUnit.class);
        ValueTransformer.TransformedValue<Tuple2<Mesh, PolygonData[]>> mesh = PolygonArrayTransformer.create().transform(Tuple2.create(unit, polygons));
        if (mesh.isDefined()) {
            polys.setParsedData(mesh.get().getB());
            polys.setParsedData(mesh.get().getA());
            geom = new Geometry("model");
            geom.setMesh(mesh.get().getA());
            geom.setModelBound((BoundingVolume)new BoundingBox());
            geom.updateModelBound();
            this.applyMaterial(geom, polys, bindings);
        } else {
            Todo.task("cannot create mesh, check this out.");
        }
        Todo.implementThis();
        return ValueTransformer.TransformedValue.create(geom);
    }
}

