/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.TangentBinormalGenerator;
import java.util.LinkedList;
import jme3dae.DAENode;
import jme3dae.FXEnhancerInfo;
import jme3dae.collada14.transformers.PolygonsTransformer;
import jme3dae.collada14.transformers.PolylistTransformer;
import jme3dae.collada14.transformers.TrianglesTransformer;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;
import jme3dae.utilities.Tuple2;

public class MeshTransformer
implements TransformerPack<Tuple2<DAENode, Bindings>, Node> {
    private final TrianglesTransformer TRIANGLES = TrianglesTransformer.create();
    private final PolylistTransformer POLYLIST = PolylistTransformer.create();
    private final PolygonsTransformer POLYGONS = PolygonsTransformer.create();

    public static MeshTransformer create() {
        return new MeshTransformer();
    }

    private MeshTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Node> transform(Tuple2<DAENode, Bindings> value) {
        ValueTransformer.TransformedValue<Geometry> geom;
        DAENode mesh = value.getA();
        Bindings bindings = value.getB();
        Conditions.checkTrue(mesh.hasName("mesh"));
        Conditions.checkNotNull(bindings);
        Node node = null;
        LinkedList<Geometry> geometries = new LinkedList<Geometry>();
        for (DAENode lines : mesh.getChildren("lines")) {
            Todo.task("parse lines");
        }
        for (DAENode linestrips : mesh.getChildren("linestrips")) {
            Todo.task("parse linestrips");
        }
        for (DAENode polygons : mesh.getChildren("polygons")) {
            geom = this.POLYGONS.transform(Tuple2.create(polygons, bindings));
            if (!geom.isDefined()) continue;
            geometries.add(geom.get());
        }
        for (DAENode polylist : mesh.getChildren("polylist")) {
            geom = this.POLYLIST.transform(Tuple2.create(polylist, bindings));
            if (!geom.isDefined()) continue;
            geometries.add(geom.get());
        }
        for (DAENode triangles : mesh.getChildren("triangles")) {
            geom = this.TRIANGLES.transform(Tuple2.create(triangles, bindings));
            if (!geom.isDefined()) continue;
            geometries.add(geom.get());
        }
        for (DAENode trifans : mesh.getChildren("trifans")) {
            Todo.task("parse trifans");
        }
        for (DAENode tristrips : mesh.getChildren("tristrips")) {
            Todo.task("parse tristrips");
        }
        for (DAENode extra : mesh.getChildren("extra")) {
            Todo.task("parse extra");
        }
        if (!geometries.isEmpty()) {
            node = new Node();
            FXEnhancerInfo fx = mesh.getRootNode().getParsedData(FXEnhancerInfo.class);
            for (Geometry geometry : geometries) {
                if (fx.getAutoBump()) {
                    this.generateTangentBinormals(geometry);
                }
                node.attachChild((Spatial)geometry);
                if (geometry.getModelBound() == null) {
                    geometry.setModelBound((BoundingVolume)new BoundingBox());
                }
                geometry.updateModelBound();
            }
        }
        return ValueTransformer.TransformedValue.create(node);
    }

    private void generateTangentBinormals(Geometry geometry) {
        Mesh mesh = geometry.getMesh();
        VertexBuffer bibuffer = mesh.getBuffer(VertexBuffer.Type.Binormal);
        VertexBuffer tanbuffer = mesh.getBuffer(VertexBuffer.Type.Tangent);
        VertexBuffer texCoordBuffer = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        VertexBuffer coordBuffer = mesh.getBuffer(VertexBuffer.Type.Position);
        if (mesh != null && bibuffer == null || tanbuffer == null && texCoordBuffer != null && coordBuffer != null) {
            try {
                TangentBinormalGenerator.generate((Mesh)mesh);
            }
            catch (NullPointerException ex) {
                Todo.task("Check why this generates a npe");
            }
        }
    }
}

