/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.DAENode;
import jme3dae.FXEnhancerInfo;
import jme3dae.collada14.transformers.ColorRGBATransformer;
import jme3dae.collada14.transformers.TextureElementTransformer;
import jme3dae.materials.BlinnMaterialGenerator;
import jme3dae.materials.ConstantMaterialGenerator;
import jme3dae.materials.FXBumpMaterialGenerator;
import jme3dae.materials.LambertMaterialGenerator;
import jme3dae.materials.PhongMaterialGenerator;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;
import jme3dae.utilities.Tuple2;

public class LibraryMaterialsTransformer
implements TransformerPack<Tuple2<DAENode, AssetManager>, Void> {
    private final ColorRGBATransformer COLOR = ColorRGBATransformer.create();
    private final TextureElementTransformer TEXTURE = TextureElementTransformer.create();

    public static LibraryMaterialsTransformer create() {
        return new LibraryMaterialsTransformer();
    }

    private LibraryMaterialsTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Void> transform(Tuple2<DAENode, AssetManager> value) {
        DAENode libraryMaterials = value.getA();
        AssetManager assetManager = value.getB();
        if (assetManager != null) {
            Conditions.checkTrue(libraryMaterials.hasName("library_materials"), "expected library_materials, got " + libraryMaterials);
            DAENode optionalAsset = libraryMaterials.getChild("asset");
            List<DAENode> optionalExtras = libraryMaterials.getChildren("extra");
            List<DAENode> materials = libraryMaterials.getChildren("material");
            if (optionalAsset.isDefined()) {
                Todo.task("implement parsing of asset element");
            }
            if (!optionalExtras.isEmpty()) {
                Todo.task("implements parsing of extra elements");
            }
            Conditions.checkFalse(materials.isEmpty(), "Collada 1.4.1 requires at least one material element in library_materials");
            for (DAENode material : materials) {
                this.parseMaterial(material, assetManager);
            }
        } else {
            System.err.println("AssetManager is null, testing?");
        }
        return ValueTransformer.TransformedValue.create(null);
    }

    private void parseMaterial(DAENode material, AssetManager assetManager) {
        DAENode optionalAsset = material.getChild("asset");
        if (optionalAsset.isDefined()) {
            Todo.task("parse material asset");
        }
        DAENode instanceEffect = material.getChild("instance_effect");
        Conditions.checkTrue(instanceEffect.isDefined(), "Collada 1.4.1 requires an instance_effect child for material");
        List<DAENode> optionalExtras = material.getChildren("extra");
        if (!optionalExtras.isEmpty()) {
            Todo.task("parse material extra");
        }
        this.parseInstanceEffect(material, instanceEffect, assetManager);
    }

    private void parseInstanceEffect(DAENode material, DAENode instanceEffect, AssetManager assetManager) {
        ValueTransformer.TransformedValue<String> url = instanceEffect.getAttribute("url", TEXT);
        Conditions.checkTrue(url.isDefined(), "Collada 1.4.1 requires an url attribute for instance_effect element");
        instanceEffect.getChildren("technique_hint");
        DAENode effect = instanceEffect.getLinkedNode(url.get());
        if (effect.isDefined()) {
            this.parseEffect(material, instanceEffect, effect, assetManager);
        } else {
            Todo.task("effect not found for link " + url.get() + ": external reference or a bug?");
        }
    }

    private void parseEffect(DAENode material, DAENode instanceEffect, DAENode effect, AssetManager assetManager) {
        DAENode asset = effect.getChild("asset");
        List<DAENode> annotateList = effect.getChildren("annotate");
        List<DAENode> imageList = effect.getChildren("image");
        List<DAENode> newparamList = effect.getChildren("newparam");
        List<DAENode> profileCGList = effect.getChildren("profile_CG");
        List<DAENode> profileGLESList = effect.getChildren("profile_GLES");
        List<DAENode> profileGLSLList = effect.getChildren("profile_GLSL");
        List<DAENode> profileCOMMONList = effect.getChildren("profile_COMMON");
        List<DAENode> extraList = effect.getChildren("extra");
        if (asset.isDefined()) {
            Todo.task("implement asset parsing for effect");
        }
        if (!annotateList.isEmpty()) {
            Todo.task("implement annotate list parsing");
        }
        if (!imageList.isEmpty()) {
            Todo.task("implement image list parsing");
        }
        if (!newparamList.isEmpty()) {
            Todo.task("implement image list parsing");
        }
        if (!profileCGList.isEmpty()) {
            Todo.task("implement profileCG list parsing");
        }
        if (!profileGLESList.isEmpty()) {
            Todo.task("implement profileGLES list parsing");
        }
        if (!profileGLSLList.isEmpty()) {
            Todo.task("implements profileGLSL list parsing");
        }
        if (!extraList.isEmpty()) {
            Todo.task("implement extra list parsing");
        }
        if (profileCOMMONList.size() > 1) {
            Todo.task("implement multiple profile_COMMON parsing");
        }
        if (!profileCOMMONList.isEmpty()) {
            FXEnhancerInfo fx;
            boolean twoSided;
            DAENode profileCommon = profileCOMMONList.get(0);
            DAENode technique = profileCommon.getChild("technique");
            Conditions.checkTrue(technique.isDefined(), "Collada 1.4.1 requires one technique child for profile_COMMON");
            DAENode phong = technique.getChild("phong");
            DAENode lambert = technique.getChild("lambert");
            DAENode blinn = technique.getChild("blinn");
            DAENode constant = technique.getChild("constant");
            if (phong.isDefined()) {
                this.parsePhong(material, instanceEffect, effect, phong, assetManager);
            } else if (lambert.isDefined()) {
                this.parseLambert(material, instanceEffect, effect, lambert, assetManager);
            } else if (blinn.isDefined()) {
                this.parseBlinn(material, instanceEffect, effect, blinn, assetManager);
            } else if (constant.isDefined()) {
                this.parseConstant(material, instanceEffect, effect, constant, assetManager);
            } else {
                Todo.task("parse material (no phong, blinn or lambert found)");
            }
            Material mat = material.getParsedData(Material.class);
            if (mat != null && (twoSided = (fx = material.getRootNode().getParsedData(FXEnhancerInfo.class)).getTwoSided())) {
                mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            }
        }
        if (!extraList.isEmpty()) {
            for (DAENode extra : extraList) {
                this.parseExtra(extra, material.getParsedData(Material.class));
            }
        }
    }

    private void parsePhong(DAENode material, DAENode instanceEffect, DAENode effect, DAENode phong, AssetManager assetManager) {
        DAENode emission = phong.getChild("emission");
        DAENode ambient = phong.getChild("ambient");
        DAENode diffuse = phong.getChild("diffuse");
        DAENode specular = phong.getChild("specular");
        DAENode shininess = phong.getChild("shininess");
        DAENode reflective = phong.getChild("reflective");
        DAENode reflectivity = phong.getChild("reflectivity");
        DAENode transparent = phong.getChild("transparent");
        DAENode transparency = phong.getChild("transparency");
        DAENode indexOfRefraction = phong.getChild("index_of_refraction");
        ValueTransformer.TransformedValue<ColorRGBA> emissionColor = emission.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> ambientColor = ambient.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> diffuseColor = diffuse.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> specularColor = specular.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> shininessFloat = shininess.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> reflectiveColor = reflective.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> reflectivityFloat = reflectivity.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> transparentColor = transparent.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> transparencyFloat = transparency.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Float> indexOfRefractionFloat = indexOfRefraction.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Texture> emissionTexture = emission.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> ambientTexture = ambient.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> diffuseTexture = diffuse.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> specularTexture = specular.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> reflectiveTexture = specular.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> transparentTexture = transparent.getChildValue("texture", this.TEXTURE);
        FXEnhancerInfo fx = material.getRootNode().getParsedData(FXEnhancerInfo.class);
        if (fx.getUseJME3Materials()) {
            FXBumpMaterialGenerator bump = FXBumpMaterialGenerator.create(assetManager, fx.getAutoBump() && diffuseTexture.isDefined());
            bump.setTexture(diffuseTexture.get());
            bump.setAmbient(ambientColor.get());
            bump.setDiffuse(diffuseColor.get());
            bump.setShininess(shininessFloat.get());
            material.setParsedData(bump.get());
        } else {
            PhongMaterialGenerator m = PhongMaterialGenerator.create(assetManager);
            m.setAmbient(ambientColor.get());
            m.setDiffuse(diffuseColor.get());
            m.setSpecular(specularColor.get());
            m.setAmbient(ambientTexture.get());
            m.setDiffuse(diffuseTexture.get());
            m.setSpecular(specularTexture.get());
            material.setParsedData(m.get());
        }
    }

    private void parseLambert(DAENode material, DAENode instanceEffect, DAENode effect, DAENode lambert, AssetManager assetManager) {
        DAENode emissionNode = lambert.getChild("emission");
        DAENode ambientNode = lambert.getChild("ambient");
        DAENode diffuseNode = lambert.getChild("diffuse");
        DAENode reflective = lambert.getChild("reflective");
        DAENode reflectivity = lambert.getChild("reflectivity");
        DAENode transparent = lambert.getChild("transparent");
        DAENode transparency = lambert.getChild("transparency");
        DAENode indexOfRefraction = lambert.getChild("index_of_refraction");
        ValueTransformer.TransformedValue<ColorRGBA> emissionColor = emissionNode.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> ambientColor = ambientNode.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> diffuseColor = diffuseNode.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> reflectiveColor = reflective.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> reflectivityFloat = reflectivity.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> transparentColor = transparent.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> transparencyFloat = transparency.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Float> indexOfRefractionFloat = indexOfRefraction.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Texture> emissionTexture = emissionNode.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> ambientTexture = ambientNode.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> diffuseTexture = diffuseNode.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> reflectiveTexture = reflective.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> transparentTexture = transparent.getChildValue("texture", this.TEXTURE);
        FXEnhancerInfo fx = material.getRootNode().getParsedData(FXEnhancerInfo.class);
        if (fx.getUseJME3Materials()) {
            FXBumpMaterialGenerator bump = FXBumpMaterialGenerator.create(assetManager, fx.getAutoBump() && diffuseTexture.isDefined());
            bump.setTexture(diffuseTexture.get());
            bump.setAmbient(ambientColor.get());
            bump.setDiffuse(diffuseColor.get());
            material.setParsedData(bump.get());
        } else {
            LambertMaterialGenerator m = LambertMaterialGenerator.create(assetManager);
            m.setAmbient(ambientColor.get());
            m.setDiffuse(diffuseColor.get());
            m.setDiffuse(diffuseTexture.get());
            material.setParsedData(m.get());
        }
    }

    private void parseBlinn(DAENode material, DAENode instanceEffect, DAENode effect, DAENode blinn, AssetManager assetManager) {
        DAENode emission = blinn.getChild("emission");
        DAENode ambient = blinn.getChild("ambient");
        DAENode diffuse = blinn.getChild("diffuse");
        DAENode specular = blinn.getChild("specular");
        DAENode shininess = blinn.getChild("shininess");
        DAENode reflective = blinn.getChild("reflective");
        DAENode reflectivity = blinn.getChild("reflectivity");
        DAENode transparent = blinn.getChild("transparent");
        DAENode transparency = blinn.getChild("transparency");
        DAENode indexOfRefraction = blinn.getChild("index_of_refraction");
        ValueTransformer.TransformedValue<ColorRGBA> emissionColor = emission.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> ambientColor = ambient.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> diffuseColor = diffuse.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> specularColor = specular.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> shininessFloat = shininess.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> reflectiveColor = reflective.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> reflectivityFloat = reflectivity.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> transparentColor = transparent.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> transparencyFloat = transparency.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Float> indexOfRefractionFloat = indexOfRefraction.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Texture> emissionTexture = emission.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> ambientTexture = ambient.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> diffuseTexture = diffuse.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> specularTexture = specular.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> reflectiveTexture = specular.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> transparentTexture = transparent.getChildValue("texture", this.TEXTURE);
        FXEnhancerInfo fx = material.getRootNode().getParsedData(FXEnhancerInfo.class);
        if (fx.getUseJME3Materials()) {
            FXBumpMaterialGenerator bump = FXBumpMaterialGenerator.create(assetManager, fx.getAutoBump() && diffuseTexture.isDefined());
            bump.setTexture(diffuseTexture.get());
            bump.setAmbient(ambientColor.get());
            bump.setDiffuse(diffuseColor.get());
            bump.setShininess(shininessFloat.get());
            material.setParsedData(bump.get());
        } else {
            BlinnMaterialGenerator m = BlinnMaterialGenerator.create(assetManager);
            m.setAmbient(ambientColor.get());
            m.setDiffuse(diffuseColor.get());
            m.setDiffuse(diffuseTexture.get());
            m.setSpecular(specularTexture.get());
            m.setSpecular(specularColor.get());
            material.setParsedData(m.get());
        }
    }

    private void parseConstant(DAENode material, DAENode instanceEffect, DAENode effect, DAENode constant, AssetManager assetManager) {
        DAENode emission = constant.getChild("emission");
        DAENode reflective = constant.getChild("reflective");
        DAENode reflectivity = constant.getChild("reflectivity");
        DAENode transparent = constant.getChild("transparent");
        DAENode transparency = constant.getChild("transparency");
        DAENode indexOfRefraction = constant.getChild("index_of_refraction");
        ValueTransformer.TransformedValue<ColorRGBA> emissionColor = emission.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<ColorRGBA> reflectiveColor = reflective.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> reflectivityFloat = reflectivity.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<ColorRGBA> transparentColor = transparent.getChild("color").getContent(this.COLOR);
        ValueTransformer.TransformedValue<Float> transparencyFloat = transparency.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Float> indexOfRefractionFloat = indexOfRefraction.getChild("float").getContent(FLOAT);
        ValueTransformer.TransformedValue<Texture> emissionTexture = emission.getChildValue("texture", this.TEXTURE);
        ValueTransformer.TransformedValue<Texture> transparentTexture = transparent.getChildValue("texture", this.TEXTURE);
        ConstantMaterialGenerator m = ConstantMaterialGenerator.create(assetManager);
        m.setAmbient(emissionColor.get());
        m.setDiffuse(emissionColor.get());
        m.setSpecular(emissionColor.get());
        material.setParsedData(m.get());
    }

    private void parseExtra(DAENode extra, Material material) {
        if (material != null) {
            List<DAENode> techniques = extra.getChildren("technique");
            for (DAENode tech : techniques) {
                DAENode ds;
                ValueTransformer.TransformedValue<Integer> content;
                ValueTransformer.TransformedValue<String> profileValue = tech.getAttribute("profile", TEXT);
                if (!profileValue.contains("GOOGLEEEARTH") || !(content = (ds = tech.getChild("double_sided")).getContent(INTEGER)).contains(1)) continue;
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "GOOGLEEARTH double sided attribute detected");
                material.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            }
        }
    }
}

