/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.asset.AssetManager;
import com.jme3.texture.Texture;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.ColladaInfo;
import jme3dae.DAENode;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.FileType;
import jme3dae.utilities.FileTypeFinder;
import jme3dae.utilities.HexSequenceTransformer;
import jme3dae.utilities.MEMAssetLocator;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;
import jme3dae.utilities.Tuple2;

public class LibraryImagesTransformer
implements TransformerPack<Tuple2<DAENode, AssetManager>, Void> {
    private final HexSequenceTransformer HEX_SEQUENCE = HexSequenceTransformer.create();

    public static LibraryImagesTransformer create() {
        return new LibraryImagesTransformer();
    }

    private LibraryImagesTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Void> transform(Tuple2<DAENode, AssetManager> value) {
        DAENode libraryImagesNode = value.getA();
        AssetManager assetManager = value.getB();
        if (libraryImagesNode != null && libraryImagesNode.isDefined() && assetManager != null) {
            this.transform(libraryImagesNode, assetManager);
        }
        return ValueTransformer.TransformedValue.create(null);
    }

    private void transform(DAENode libraryImagesNode, AssetManager assetManager) {
        List<DAENode> effectList;
        DAENode assetNode = libraryImagesNode.getChild("asset");
        DAENode extraNode = libraryImagesNode.getChild("extra");
        if (assetNode.isDefined()) {
            Todo.parse(assetNode);
        }
        if (extraNode.isDefined()) {
            Todo.parse(extraNode);
        }
        if (!(effectList = libraryImagesNode.getChildren("effect")).isEmpty()) {
            Todo.task("implement parsing of effect list");
        }
        List<DAENode> imageList = libraryImagesNode.getChildren("image");
        for (DAENode imageNode : imageList) {
            this.parseImageNode(imageNode, assetManager);
        }
    }

    private void parseImageNode(DAENode imageNode, AssetManager assetManager) {
        ValueTransformer.TransformedValue<byte[]> imageData = imageNode.getChild("data").getContent(this.HEX_SEQUENCE);
        ValueTransformer.TransformedValue<String> initFrom = imageNode.getChild("init_from").getContent(TEXT);
        String id = imageNode.getAttribute("id", TEXT).get();
        Texture texture = null;
        if (imageData.isDefined()) {
            ValueTransformer.TransformedValue<String> format = imageNode.getAttribute("format", TEXT);
            FileType fileType = FileTypeFinder.create().getFileType(imageData.get());
            id = format.isDefined() ? "mem://" + id + "." + format.get() : (fileType != FileType.UNKNOWNW ? "mem://" + id + "." + fileType.getExtension() : null);
            if (id != null) {
                assetManager.registerLocator("mem://", MEMAssetLocator.class);
                texture = assetManager.loadTexture(id);
            }
        }
        if (initFrom.isDefined()) {
            DAENode collada = imageNode.getRootNode();
            ColladaInfo colladaInfo = collada.getParsedData(ColladaInfo.class);
            String folder = colladaInfo.getInfo().getKey().getFolder();
            String location = initFrom.get();
            try {
                URI path = new URI(folder + "/" + location).normalize();
                texture = assetManager.loadTexture(path.toString());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Exception while loading texture " + location);
            }
            if (texture != null) {
                texture.setWrap(Texture.WrapMode.Repeat);
                texture.setMagFilter(Texture.MagFilter.Bilinear);
                texture.setMinFilter(Texture.MinFilter.Trilinear);
            }
        }
        if (texture == null) {
            Todo.task("Cannot create texture for node " + imageNode);
        } else {
            imageNode.setParsedData(texture);
        }
    }
}

