/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.Track;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.collada14.ChannelTarget;
import jme3dae.collada14.ColladaSpec141;
import jme3dae.collada14.transformers.GeometryTransformer;
import jme3dae.collada14.transformers.MeshTransformer;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.Matrix4fTransformer;
import jme3dae.utilities.Tuple2;
import jme3dae.utilities.VertexSkinningData;

public class InstanceControllerTransformer
extends GeometryTransformer<DAENode, Node> {
    public static InstanceControllerTransformer create() {
        return new InstanceControllerTransformer();
    }

    private InstanceControllerTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Node> transform(DAENode instanceController) {
        Conditions.checkTrue(instanceController.isDefined());
        Conditions.checkTrue(instanceController.hasName("instance_controller"));
        Node result = null;
        DAENode controller = instanceController.getLinkedURL();
        DAENode skin = controller.getChild("skin");
        DAENode mesh = skin.getLinkedSource().getChild("mesh");
        DAENode bindMaterial = instanceController.getChild("bind_material");
        Bindings bindings = Bindings.create();
        bindings.put("bind_material", bindMaterial);
        ValueTransformer.TransformedValue<Node> geom = MeshTransformer.create().transform(Tuple2.create(mesh, bindings));
        if (geom.isDefined()) {
            List<DAENode> geomElementList = mesh.getChildren("triangles", "polygons", "polylist");
            DAENode vertexWeights = skin.getChild("vertex_weights");
            DAENode joint = vertexWeights.getChild("input", "semantic", ColladaSpec141.Semantic.JOINT.name());
            DAENode weight = vertexWeights.getChild("input", "semantic", ColladaSpec141.Semantic.WEIGHT.name());
            String[] jointNames = joint.getLinkedSource().getChild("IDREF_array").getContent(NAME_LIST).get();
            DAENode[] boneNodes = new DAENode[jointNames.length];
            Bone[] jmeBones = new Bone[jointNames.length];
            Matrix4f[] matrices = this.getSkinJointsMatrices(skin);
            for (int i = 0; i < jointNames.length; ++i) {
                String sid = jointNames[i];
                boneNodes[i] = instanceController.getLinkedNode(sid);
                jmeBones[i] = new Bone(sid);
                Quaternion bindRot = matrices[i].toRotationQuat();
                Vector3f bindTrans = matrices[i].toTranslationVector();
                Vector3f bindScale = Vector3f.UNIT_XYZ;
                jmeBones[i].setBindTransforms(bindTrans, bindRot, bindScale);
                boneNodes[i].setParsedData(jmeBones[i]);
            }
            this.mapBoneTree(boneNodes, jmeBones);
            float[] weights = weight.getLinkedSource().getChild("float_array").getContent(FLOAT_LIST).get();
            int[] vcount = vertexWeights.getChild("vcount").getContent(INTEGER_LIST).get();
            IntBuffer v = IntBuffer.wrap(vertexWeights.getChild("v").getContent(INTEGER_LIST).get());
            LinkedList<VertexSkinningData> vsdList = new LinkedList<VertexSkinningData>();
            for (int i = 0; i < vcount.length; ++i) {
                int size = vcount[i];
                for (int j = 0; j < size; ++j) {
                    VertexSkinningData vsd = VertexSkinningData.create(i, v.get(), weights[v.get()]);
                    vsdList.add(vsd);
                }
            }
            Skeleton skeleton = new Skeleton(jmeBones);
            skeleton.setBindingPose();
            for (DAENode geomNode : geomElementList) {
                Mesh jmeMesh = this.applySkinData(geomNode, vsdList);
                this.createBindPose(jmeMesh);
            }
            result = new Node(instanceController.getParent().getAttribute("name", TEXT).get());
            result.attachChild((Spatial)geom.get());
            DAENode libraryAnimations = instanceController.getRootNode().findDescendant("library_animations");
            AnimControl control = this.createAnimControl(geom.get(), libraryAnimations, geomElementList, skeleton);
            geom.get().setName(instanceController.getAttribute("url", TEXT).get());
            geom.get().addControl((Control)control);
            control.setEnabled(false);
        }
        return ValueTransformer.TransformedValue.create(result);
    }

    private Mesh applySkinData(DAENode geomNode, List<VertexSkinningData> vsdList) {
        PolygonData[] polygons = geomNode.getParsedData(PolygonData[].class);
        Mesh jmeMesh = geomNode.getParsedData(Mesh.class);
        int meshVCount = jmeMesh.getVertexCount();
        VertexBuffer wb = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        VertexBuffer bi = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        FloatBuffer wbuffer = FloatBuffer.allocate(meshVCount * 4);
        ByteBuffer ibuffer = ByteBuffer.allocate(meshVCount * 4);
        for (int i = 0; i < polygons.length; ++i) {
            PolygonData polygonData = polygons[i];
            polygonData.pushVertexSkinningData(vsdList);
            polygonData.popVertexSkinningData(ibuffer, wbuffer);
        }
        wb.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, (Buffer)wbuffer);
        bi.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.UnsignedByte, (Buffer)ibuffer);
        jmeMesh.setBuffer(wb);
        jmeMesh.setBuffer(bi);
        return jmeMesh;
    }

    private void createBindPose(Mesh jmeMesh) {
        VertexBuffer pos = jmeMesh.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer bindPos = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
        bindPos.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)pos.getData()));
        jmeMesh.setBuffer(bindPos);
        pos.setUsage(VertexBuffer.Usage.Stream);
        VertexBuffer norm = jmeMesh.getBuffer(VertexBuffer.Type.Normal);
        if (norm != null) {
            VertexBuffer bindNorm = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
            bindNorm.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)norm.getData()));
            jmeMesh.setBuffer(bindNorm);
            norm.setUsage(VertexBuffer.Usage.Stream);
        }
    }

    private void mapBoneTree(DAENode[] boneNodes, Bone[] jmeBones) {
        for (int i = 0; i < boneNodes.length; ++i) {
            DAENode daeNode = boneNodes[i];
            Bone bone = jmeBones[i];
            for (DAENode c : daeNode.getChildren(new String[0])) {
                if (!c.hasParsedData(Bone.class)) continue;
                bone.addChild(c.getParsedData(Bone.class));
            }
        }
    }

    private Matrix4f[] getSkinJointsMatrices(DAENode skin) {
        DAENode joints = skin.getChild("joints");
        DAENode ibmInput = joints.getChild("input", "semantic", ColladaSpec141.Semantic.INV_BIND_MATRIX.name());
        DAENode ibmSource = ibmInput.getLinkedSource();
        DAENode floatArray = ibmSource.getChild("float_array");
        ValueTransformer.TransformedValue<Matrix4f[]> matrices = floatArray.getContent(Matrix4fTransformer.create());
        Conditions.checkTrue(joints.isDefined());
        Conditions.checkTrue(ibmInput.isDefined());
        Conditions.checkTrue(ibmSource.isDefined());
        Conditions.checkTrue(floatArray.isDefined());
        Conditions.checkTrue(matrices.isDefined());
        return matrices.get();
    }

    private AnimControl createAnimControl(Node parent, DAENode animationsNode, List<DAENode> geomElementList, Skeleton skeleton) {
        Mesh[] meshes = new Mesh[geomElementList.size()];
        int index = 0;
        for (DAENode geomNode : geomElementList) {
            meshes[index] = geomNode.getParsedData(Mesh.class);
            ++index;
        }
        Animation[] animations = this.createAnimations(animationsNode, skeleton);
        AnimControl animation = new AnimControl(skeleton);
        animation.setAnimations(new HashMap());
        for (Animation Animation2 : animations) {
            animation.addAnim(Animation2);
        }
        animation.setEnabled(false);
        return animation;
    }

    private Animation[] createAnimations(DAENode animationsNode, Skeleton skeleton) {
        ArrayList<Animation> list = new ArrayList<Animation>();
        for (int i = 0; i < skeleton.getBoneCount(); ++i) {
            Bone bone = skeleton.getBone(i);
            List<Animation> animations = this.createAnimationList(animationsNode, bone, skeleton);
            list.addAll(animations);
        }
        return list.toArray(new Animation[list.size()]);
    }

    private List<Animation> createAnimationList(DAENode animationsNode, Bone bone, Skeleton skeleton) {
        LinkedList<Animation> animations = new LinkedList<Animation>();
        List<DAENode> animationNodes = this.getAnimationsNodeForBone(animationsNode, bone);
        for (DAENode node : animationNodes) {
            Animation anim = this.createAnimation(node, bone, skeleton);
            animations.add(anim);
        }
        return animations;
    }

    private List<DAENode> getAnimationsNodeForBone(DAENode animationLibraryNodes, Bone bone) {
        List<DAENode> animationNodes = animationLibraryNodes.getChildren("animation");
        LinkedList<DAENode> AnimationNodes = new LinkedList<DAENode>();
        for (DAENode node : animationNodes) {
            ValueTransformer.TransformedValue<String> targetValue = node.getChild("channel").getAttribute("target", TEXT);
            if (!targetValue.isDefined()) continue;
            String targetBone = targetValue.get().substring(0, targetValue.get().indexOf(47));
            if (!bone.getName().equals(targetBone)) continue;
            AnimationNodes.add(node);
        }
        return AnimationNodes;
    }

    private Animation createAnimation(DAENode animationNode, Bone bone, Skeleton skeleton) {
        DAENode channel = animationNode.getChild("channel");
        DAENode sampler = animationNode.getChild("sampler");
        DAENode times = sampler.getChild("input", "semantic", ColladaSpec141.Semantic.INPUT.name()).getLinkedSource();
        DAENode values = sampler.getChild("input", "semantic", ColladaSpec141.Semantic.OUTPUT.name()).getLinkedSource();
        float[] timeValues = times.getChild("float_array").getContent(FLOAT_LIST).get();
        float[] outputValues = values.getChild("float_array").getContent(FLOAT_LIST).get();
        ChannelTarget channelTarget = ChannelTarget.forName(channel.getAttribute("target", TEXT).get());
        Conditions.checkTrue(sampler.isDefined());
        Conditions.checkTrue(times.isDefined());
        Conditions.checkTrue(values.isDefined());
        Conditions.checkTrue(channel.isDefined());
        Conditions.checkNotNull(channelTarget);
        Conditions.checkNotNull(timeValues);
        Conditions.checkNotNull(outputValues);
        Transform[] transformList = (Transform[])channelTarget.transform(outputValues).get();
        Conditions.checkNotNull(transformList);
        Conditions.checkValue(transformList.length, timeValues.length);
        int boneIndex = skeleton.getBoneIndex(bone);
        float animationLength = this.max(timeValues);
        Quaternion[] rotations = this.getRotations(transformList);
        Vector3f[] translations = this.getTranslations(transformList);
        BoneTrack track = new BoneTrack(boneIndex, timeValues, translations, rotations);
        Animation anim = new Animation(animationNode.getAttribute("id", TEXT).get(), animationLength);
        anim.setTracks((Track[])new BoneTrack[]{track});
        return anim;
    }

    private float max(float[] timeValues) {
        float m = 0.0f;
        for (int i = 0; i < timeValues.length; ++i) {
            m = Math.max(m, timeValues[i]);
        }
        return m;
    }

    private Quaternion[] getRotations(Transform[] transformList) {
        Quaternion[] result = new Quaternion[transformList.length];
        for (int i = 0; i < transformList.length; ++i) {
            Transform transform = transformList[i];
            result[i] = transform.getRotation();
        }
        return result;
    }

    private Vector3f[] getTranslations(Transform[] transformList) {
        Vector3f[] result = new Vector3f[transformList.length];
        for (int i = 0; i < transformList.length; ++i) {
            Transform transform = transformList[i];
            result[i] = transform.getTranslation();
        }
        return result;
    }
}

