/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import jme3dae.DAENode;
import jme3dae.collada14.ColladaSpec141;
import jme3dae.collada14.transformers.InputShared;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;

public class InputSharedTransformer
implements TransformerPack<DAENode, InputShared> {
    public static InputSharedTransformer create() {
        return new InputSharedTransformer();
    }

    private InputSharedTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<InputShared> transform(DAENode value) {
        InputShared result = null;
        if (value.hasName("input")) {
            ValueTransformer.TransformedValue<Integer> offset = value.getAttribute("offset", INTEGER);
            ValueTransformer.TransformedValue<ColladaSpec141.Semantic> semantic = value.getAttribute("semantic", SEMANTIC);
            DAENode linkedSource = value.getLinkedSource();
            if (semantic.contains(ColladaSpec141.Semantic.VERTEX)) {
                linkedSource = linkedSource.getChild("input").getLinkedSource();
            }
            if (offset.isDefined() && linkedSource.isDefined() && semantic.isDefined()) {
                ValueTransformer.TransformedValue<Integer> set = value.getAttribute("set", INTEGER);
                Todo.task("Spec says this can be empty");
                ValueTransformer.TransformedValue<String[]> idrefArray = linkedSource.getChild("IDREF_array").getContent(NAME_LIST);
                ValueTransformer.TransformedValue<String[]> nameArray = linkedSource.getChild("Name_array").getContent(NAME_LIST);
                ValueTransformer.TransformedValue<boolean[]> boolArray = linkedSource.getChild("bool_array").getContent(BOOLEAN_LIST);
                ValueTransformer.TransformedValue<float[]> floatArray = linkedSource.getChild("float_array").getContent(FLOAT_LIST);
                ValueTransformer.TransformedValue<int[]> intArray = linkedSource.getChild("int_array").getContent(INTEGER_LIST);
                DAENode tcomm = linkedSource.getChild("technique_common");
                DAENode accessor = tcomm.getChild("accessor");
                ValueTransformer.TransformedValue<Integer> stride = accessor.getAttribute("stride", INTEGER);
                result = InputShared.create(semantic.get(), offset.get(), stride.get(), set.get(), idrefArray.get(), nameArray.get(), boolArray.get(), floatArray.get(), intArray.get());
            } else {
                Todo.checkParsingOf(value, "offset, linked source or semantic not found");
            }
        }
        return ValueTransformer.TransformedValue.create(result);
    }
}

