/*
 * Decompiled with CFR 0.152.
 */
package jme3dae;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.plugins.AWTLoader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import jme3dae.ColladaDocumentFactory;
import jme3dae.ColladaLoader;
import jme3dae.FXEnhancerInfo;

public class Main
extends SimpleApplication {
    private static volatile String model;
    private static volatile String modelParent;
    private AnimControl controlledAnimation;
    private Spatial debugMesh;

    public static void main(String[] args) throws MalformedURLException, URISyntaxException {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getParent() + chooser.getSelectedFile().getName());
            modelParent = chooser.getSelectedFile().getParent();
            model = chooser.getSelectedFile().getName();
        } else {
            System.exit(-1);
        }
        Main main = new Main();
        main.setShowSettings(false);
        main.start();
    }

    public void simpleInitApp() {
        this.renderer.setBackgroundColor(ColorRGBA.Gray);
        this.inputManager.addMapping("animate", new Trigger[]{new KeyTrigger(2)});
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String string, boolean bln, float f) {
                if (Main.this.controlledAnimation != null) {
                    AnimChannel channel = Main.this.controlledAnimation.createChannel();
                    channel.setSpeed(0.001f);
                    channel.setAnim("l_hip_rotateY");
                    Main.this.controlledAnimation.setEnabled(!Main.this.controlledAnimation.isEnabled());
                }
            }
        }, new String[]{"animate"});
        ColladaDocumentFactory.setFXEnhance(FXEnhancerInfo.create(FXEnhancerInfo.NormalMapGenerator.ON, FXEnhancerInfo.TwoSidedMaterial.ON, FXEnhancerInfo.IgnoreMeasuringUnit.ON));
        this.assetManager.registerLoader(AWTLoader.class, new String[]{"tif"});
        this.assetManager.registerLoader(ColladaLoader.class, new String[]{"dae"});
        this.assetManager.registerLocator(modelParent, FileLocator.class);
        Spatial scene = this.assetManager.loadModel(model);
        scene.updateModelBound();
        Node node = (Node)scene;
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White.clone());
        dl.setDirection(new Vector3f(1.0f, 1.0f, 1.0f).normalizeLocal().negateLocal());
        node.addLight((Light)dl);
        PointLight pl = new PointLight();
        pl.setColor(ColorRGBA.Gray.clone());
        pl.setPosition(new Vector3f(0.0f, 100.0f, -100.0f));
        pl.setRadius(1000.0f);
        node.addLight((Light)pl);
        this.rootNode.attachChild(scene);
        this.flyCam.setMoveSpeed(1.0f);
        this.cam.setFrustumFar(25.0f);
        node.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        try {
            this.inspect(node);
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void inspect(Node node) throws Exception {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(node);
        while (!list.isEmpty()) {
            AnimControl animation;
            Spatial s = (Spatial)list.pop();
            if (s instanceof Node) {
                list.addAll(((Node)s).getChildren());
            }
            if ((animation = (AnimControl)s.getControl(AnimControl.class)) == null) continue;
            this.debugAnimation(animation);
            this.controlledAnimation = animation;
            this.debugMesh(s);
        }
    }

    private void debugMesh(Spatial s) {
        this.debugMesh = s;
        Spatial g = s;
        int index = 0;
        while (!(g instanceof Geometry) & index++ < 100) {
            g = ((Node)s).getChild(0);
        }
        Mesh mesh = ((Geometry)g).getMesh();
        VertexBuffer poseweight = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        VertexBuffer boneindex = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        FloatBuffer vbuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer wbuffer = (FloatBuffer)poseweight.getData();
        ByteBuffer bbuffer = (ByteBuffer)boneindex.getData();
        wbuffer.rewind();
        bbuffer.rewind();
        vbuffer.rewind();
        int vindex = 0;
        while (wbuffer.hasRemaining()) {
            byte[] bones = new byte[4];
            float[] weights = new float[4];
            float[] vertex = new float[3];
            vbuffer.get(vertex);
            wbuffer.get(weights);
            bbuffer.get(bones);
            System.out.println("Vertex " + vindex + " {" + this.toString(vertex) + "} : Bones {" + this.toString(bones) + "} Weights {" + this.toString(weights) + "}");
            ++vindex;
        }
        wbuffer.rewind();
        bbuffer.rewind();
    }

    private String toString(byte[] data) {
        String t = "";
        for (byte b : data) {
            t = t + b + "...";
        }
        return t.substring(0, t.length() - 3);
    }

    private String toString(float[] data) {
        String t = "";
        for (float f : data) {
            t = t + f + "...";
        }
        return t.substring(0, t.length() - 3);
    }

    private void debugAnimation(AnimControl animation) throws Exception {
        System.out.println("ANIMATION DATA");
        Skeleton skeleton = animation.getSkeleton();
        this.debugSkeleton(skeleton);
        System.out.println("Animations bound to this control: ");
        Collection animationNames = animation.getAnimationNames();
        for (String string : animationNames) {
            Animation anim = animation.getAnim(string);
            this.debugAnimation(anim);
        }
    }

    private void debugAnimation(Animation anim) throws Exception {
        System.out.println("ANIMATION: " + anim.getName());
    }

    private void debugSkeleton(Skeleton skeleton) throws Exception {
        System.out.println("SKELETON");
        int boneCount = skeleton.getBoneCount();
        System.out.println("bone count " + boneCount);
        for (int i = 0; i < boneCount; ++i) {
            Bone bone = skeleton.getBone(i);
            System.out.println("Bone: " + bone.getName());
            System.out.println("Parent: " + bone.getParent());
            System.out.print("Children: ");
            for (Bone bone1 : bone.getChildren()) {
                System.out.print("[" + bone1 + "]");
            }
            System.out.println("");
        }
    }
}

