/*
 * Decompiled with CFR 0.152.
 */
package jme3dae;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jme3dae.DAENodeDocumentRegistry;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.PlainTextTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAENode {
    private final DAENode parent;
    private final Node node;
    private final List<DAENode> children = new LinkedList<DAENode>();
    private final List<Object> parsedData = new LinkedList<Object>();
    private final DAENodeDocumentRegistry documentRegistry;
    public static final DAENode NONE = new DAENode();

    private DAENode(DAENode parent, Node node, DAENodeDocumentRegistry documentRegistry) {
        if (node == null) {
            throw new IllegalArgumentException("DAENode xml node cannot be null.");
        }
        this.parent = parent;
        this.node = node;
        this.documentRegistry = documentRegistry;
    }

    private DAENode() {
        this.parent = null;
        this.node = null;
        this.documentRegistry = null;
    }

    public static DAENode create(DAENode parent, Node node, DAENodeDocumentRegistry documentRegistry) {
        String id;
        DAENode nodeToReturn = new DAENode(parent, node, documentRegistry);
        if (node instanceof Element && !(id = ((Element)node).getAttribute("id")).isEmpty()) {
            nodeToReturn.addToDocumentRegistry(id, nodeToReturn);
        }
        return nodeToReturn;
    }

    private void addToDocumentRegistry(String id, DAENode n) {
        this.documentRegistry.addToDocumentRegistry(id, n);
    }

    public DAENode getRootNode() {
        DAENode rootNodeToReturn = this;
        while (rootNodeToReturn.getParent().isDefined()) {
            rootNodeToReturn = rootNodeToReturn.getParent();
        }
        return rootNodeToReturn;
    }

    public void setParsedData(Object data) {
        if (data != null) {
            this.parsedData.add(data);
        }
    }

    public <T> T getParsedData(Class<T> type) {
        for (Object object : this.parsedData) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return type.cast(object);
        }
        return null;
    }

    public <T> boolean hasParsedData(Class<T> type) {
        return this.parsedData == null ? null : Boolean.valueOf(type.isAssignableFrom(this.parsedData.getClass()));
    }

    public boolean isDefined() {
        return this != NONE;
    }

    public DAENode getLinkedSource() {
        Element element;
        String attribute;
        DAENode nodeToReturn = NONE;
        if (this.node instanceof Element && !(attribute = (element = (Element)this.node).getAttribute("source")).isEmpty()) {
            return this.getLinkedNode(attribute);
        }
        return nodeToReturn;
    }

    public DAENode getLinkedURL() {
        Element element;
        String attribute;
        DAENode nodeToReturn = NONE;
        if (this.node instanceof Element && !(attribute = (element = (Element)this.node).getAttribute("url")).isEmpty()) {
            return this.getLinkedNode(attribute);
        }
        return nodeToReturn;
    }

    public <R> ValueTransformer.TransformedValue<R> getAttribute(String name, ValueTransformer<String, R> parser) {
        String value = "";
        if (this.node instanceof Element) {
            value = ((Element)this.node).getAttribute(name);
        }
        return parser.transform(value);
    }

    public <R> ValueTransformer.TransformedValue<R> getContent(ValueTransformer<String, R> parser) {
        return this.node == null ? ValueTransformer.TransformedValue.create(null) : parser.transform(this.node.getTextContent());
    }

    public boolean hasName(String value) {
        if (value == null || value.isEmpty() || !this.isDefined()) {
            return false;
        }
        return this.node.getNodeName().equals(value);
    }

    public List<DAENode> getChildren(String ... names) {
        if (this.node == null || names == null) {
            return Collections.emptyList();
        }
        if (names.length == 0) {
            return this.children;
        }
        List<String> nameList = Arrays.asList(names);
        LinkedList<DAENode> result = new LinkedList<DAENode>();
        for (DAENode childNode : this.children) {
            if (!nameList.contains(childNode.getNodeName())) continue;
            result.add(childNode);
        }
        return result;
    }

    private String getNodeName() {
        return this.node != null ? this.node.getNodeName() : null;
    }

    public DAENode getChild(String name) {
        for (DAENode childNode : this.children) {
            if (!childNode.hasName(name)) continue;
            return childNode;
        }
        return NONE;
    }

    public DAENode getChild(String name, String attribute, String value) {
        for (DAENode e : this.children) {
            Element m;
            if (!e.hasName(name) || !(e.node instanceof Element) || !value.equals((m = (Element)e.node).getAttribute(attribute))) continue;
            return e;
        }
        return NONE;
    }

    public <T> ValueTransformer.TransformedValue<T> getChildValue(String name, ValueTransformer<DAENode, T> transformer) {
        DAENode daeNode = this.getChild(name);
        return daeNode.isDefined() ? transformer.transform(daeNode) : ValueTransformer.TransformedValue.create(null);
    }

    public DAENode getParent() {
        return this.parent == null ? NONE : this.parent;
    }

    void addChild(DAENode node) {
        this.children.add(node);
    }

    public DAENode getLinkedNode(String url) {
        if (url == null || url.isEmpty()) {
            return NONE;
        }
        if (url.startsWith("#")) {
            url = url.substring(1);
        }
        PlainTextTransformer parser = PlainTextTransformer.create();
        DAENode daeNodeToReturn = this.getParent();
        while (daeNodeToReturn.isDefined()) {
            if (daeNodeToReturn.getAttribute("sid", parser).contains(url)) {
                return daeNodeToReturn;
            }
            for (DAENode child : daeNodeToReturn.getChildren(new String[0])) {
                if (!child.getAttribute("sid", parser).contains(url)) continue;
                return child;
            }
            daeNodeToReturn = daeNodeToReturn.getParent();
        }
        if (!daeNodeToReturn.isDefined() && this.documentRegistry.containsURLKey(url)) {
            daeNodeToReturn = this.documentRegistry.getFromDocumentRegistry(url);
        }
        return daeNodeToReturn;
    }

    public String toString() {
        return this.node == null ? "NONE" : String.valueOf(this.node);
    }

    public DAENode findDescendant(String tag) {
        if (this == NONE) {
            return NONE;
        }
        LinkedList<DAENode> list = new LinkedList<DAENode>();
        list.add(this);
        while (!list.isEmpty()) {
            DAENode n = (DAENode)list.pop();
            if (n.hasName(tag)) {
                return n;
            }
            list.addAll(n.getChildren(new String[0]));
        }
        return NONE;
    }
}

