/*
 * Decompiled with CFR 0.152.
 */
package jme3dae;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.UrlLocator;
import com.jme3.scene.Node;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.ColladaDocumentFactory;
import jme3dae.ColladaInfo;
import jme3dae.DAELoader;
import jme3dae.DAENode;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.TextureBaseList;
import jme3dae.utilities.Tuple2;

public class ColladaLoader
implements AssetLoader {
    private static final TextureBaseList TEXTURE_BASE = new TextureBaseList();

    public static void register(AssetManager manager, ModelDirectoryUrl url) {
        manager.registerLoader(ColladaLoader.class, new String[]{"dae"});
        manager.registerLocator(url.url, UrlLocator.class);
    }

    public static void addTextureBase(String base) {
        TEXTURE_BASE.add(base);
    }

    public static void removeTextureBase(String base) {
        TEXTURE_BASE.remove(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node load(AssetInfo assetInfo) {
        InputStream in = assetInfo.openStream();
        Node node = null;
        try {
            DAENode root = DAELoader.create().load(in);
            root.setParsedData(ColladaInfo.create(assetInfo));
            root.setParsedData(TEXTURE_BASE);
            Tuple2<DAENode, AssetManager> data = Tuple2.create(root, assetInfo.getManager());
            ValueTransformer.TransformedValue<Node> jmeRoot = ColladaDocumentFactory.newColladaDocumentParser(root).transform(data);
            node = jmeRoot.get();
        }
        catch (Exception ex) {
            Logger.getLogger(ColladaLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ColladaLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return node;
    }

    public static class ModelDirectoryUrl {
        final String url;

        public ModelDirectoryUrl(String url) {
            this.url = url;
        }
    }
}

