/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.yoVariables.parameters.AbstractParameterReader;
import us.ihmc.yoVariables.parameters.ParameterData;
import us.ihmc.yoVariables.parameters.xml.Parameter;
import us.ihmc.yoVariables.parameters.xml.Parameters;
import us.ihmc.yoVariables.parameters.xml.Registry;

public class XmlParameterReader
extends AbstractParameterReader {
    private static final String prefix = "[" + XmlParameterReader.class.getSimpleName() + "]:";
    private final boolean debug;
    private final Map<String, ParameterData> parameterValues = new HashMap<String, ParameterData>();
    private final String rootNamespace;

    public XmlParameterReader(InputStream ... dataStreams) throws IOException {
        this(false, (String)null, dataStreams);
    }

    public XmlParameterReader(String rootNamespace, InputStream ... dataStreams) throws IOException {
        this(false, rootNamespace, dataStreams);
    }

    public XmlParameterReader(boolean debug, InputStream ... dataStreams) throws IOException {
        this(debug, (String)null, dataStreams);
    }

    public XmlParameterReader(boolean debug, String rootNamespace, InputStream ... dataStreams) throws IOException {
        this.debug = debug;
        this.rootNamespace = rootNamespace;
        for (InputStream dataStream : dataStreams) {
            this.readStream(dataStream, false);
        }
    }

    public void overwrite(InputStream ... overwriteParameters) throws IOException {
        for (InputStream dataStream : overwriteParameters) {
            this.readStream(dataStream, true);
        }
    }

    public void readAndOverwrite(InputStream ... overwriteParameters) throws IOException {
        for (InputStream dataStream : overwriteParameters) {
            this.readStream(dataStream, false);
        }
    }

    private void readStream(InputStream data, boolean forceOverwrite) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Parameters.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Parameters parameterRoot = (Parameters)jaxbUnmarshaller.unmarshal(data);
            if (parameterRoot.getRegistries() != null) {
                for (Registry registry : parameterRoot.getRegistries()) {
                    if (this.rootNamespace != null && !registry.getName().equals(this.rootNamespace)) continue;
                    this.addRegistry(registry.getName(), registry, forceOverwrite);
                }
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private void addRegistry(String path, Registry registry, boolean checkParameterExists) {
        if (registry.getParameters() != null) {
            for (Parameter param : registry.getParameters()) {
                ParameterData data;
                String name = path + "." + param.getName();
                if (this.parameterValues.put(name, data = new ParameterData(param.getValue(), param.getMin(), param.getMax())) != null) {
                    if (!this.debug) continue;
                    System.out.println(prefix + " overwriting " + param.getName());
                    continue;
                }
                if (!checkParameterExists) continue;
                throw new RuntimeException(prefix + " trying to overwrite parameter " + param.getName() + " but it does not exist.");
            }
        }
        if (registry.getRegistries() != null) {
            for (Registry child : registry.getRegistries()) {
                String childPath = path + "." + child.getName();
                this.addRegistry(childPath, child, checkParameterExists);
            }
        }
    }

    @Override
    protected Map<String, ParameterData> getValues() {
        return Collections.unmodifiableMap(this.parameterValues);
    }
}

