/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.math;

import java.io.PrintStream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.MatrixIO;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoMatrix
implements DMatrix,
ReshapeMatrix {
    private final int maxNumberOfRows;
    private final int maxNumberOfColumns;
    private final YoInteger numberOfRows;
    private final YoInteger numberOfColumns;
    private final YoDouble[][] variables;

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, null, null, registry);
    }

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, rowNames, null, registry);
    }

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, String[] columnNames, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, rowNames, columnNames, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        this(name, description, maxNumberOfRows, maxNumberOfColumns, null, null, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, YoRegistry registry) {
        this(name, description, maxNumberOfRows, maxNumberOfColumns, rowNames, null, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, String[] columnNames, YoRegistry registry) {
        this.maxNumberOfRows = maxNumberOfRows;
        this.maxNumberOfColumns = maxNumberOfColumns;
        this.numberOfRows = new YoInteger(name + "NumRows", registry);
        this.numberOfColumns = new YoInteger(name + "NumCols", registry);
        this.numberOfRows.set(maxNumberOfRows);
        this.numberOfColumns.set(maxNumberOfColumns);
        this.variables = new YoDouble[maxNumberOfRows][maxNumberOfColumns];
        for (int row = 0; row < maxNumberOfRows; ++row) {
            block6: for (int column = 0; column < maxNumberOfColumns; ++column) {
                switch (this.checkNames(rowNames, columnNames)) {
                    case NONE: {
                        this.variables[row][column] = new YoDouble(YoMatrix.getFieldName(name, row, column), description, registry);
                        continue block6;
                    }
                    case ROWS: {
                        this.variables[row][column] = new YoDouble(YoMatrix.getFieldName(name, rowNames[row], ""), description, registry);
                        continue block6;
                    }
                    case ROWS_AND_COLUMNS: {
                        this.variables[row][column] = new YoDouble(YoMatrix.getFieldName(name, rowNames[row], columnNames[column]), description, registry);
                    }
                }
            }
        }
    }

    public static String getFieldName(String prefix, int row, int column) {
        return YoMatrix.getFieldName(prefix, "_" + row, "_" + column);
    }

    public static String getFieldName(String prefix, String rowName, String columnName) {
        return prefix + rowName + columnName;
    }

    private NamesProvided checkNames(String[] rowNames, String[] columnNames) {
        if (rowNames == null && columnNames != null) {
            throw new IllegalArgumentException("Cannot provide column names without row names.");
        }
        if (rowNames != null && columnNames == null) {
            return this.checkNamesProvidedRows(rowNames);
        }
        if (rowNames != null && columnNames != null) {
            return this.checkNamesProvidedRowsAndColumns(rowNames, columnNames);
        }
        return NamesProvided.NONE;
    }

    private NamesProvided checkNamesProvidedRows(String[] rowNames) {
        if (rowNames.length != this.maxNumberOfRows) {
            throw new IllegalArgumentException("The number of row names must match the number of rows in the YoMatrix. Expected " + this.maxNumberOfRows + ", was " + rowNames.length);
        }
        if (this.maxNumberOfColumns > 1) {
            throw new IllegalArgumentException("The YoMatrix must be a column vector if only row names are provided, else unique names cannot be generated.");
        }
        return NamesProvided.ROWS;
    }

    private NamesProvided checkNamesProvidedRowsAndColumns(String[] rowNames, String[] columnNames) {
        if (rowNames.length != this.maxNumberOfRows) {
            throw new IllegalArgumentException("The number of row names must match the number of rows in the YoMatrix. Expected " + this.maxNumberOfRows + ", was " + rowNames.length);
        }
        if (columnNames.length != this.maxNumberOfColumns) {
            throw new IllegalArgumentException("The number of column names must match the number of columns in the YoMatrix. Expected " + this.maxNumberOfColumns + ", was " + columnNames.length);
        }
        return NamesProvided.ROWS_AND_COLUMNS;
    }

    public void scale(double scale) {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.unsafe_set(row, col, this.unsafe_get(row, col) * scale);
            }
        }
    }

    public void scale(double scale, DMatrix matrix) {
        if (matrix.getNumRows() != this.getNumRows() || matrix.getNumCols() != this.getNumCols()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. Expected " + this.getNumRows() + "x" + this.getNumCols() + ", was " + matrix.getNumRows() + "x" + matrix.getNumCols());
        }
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.unsafe_set(row, col, matrix.unsafe_get(row, col) * scale);
            }
        }
    }

    public void add(DMatrix a, DMatrix b) {
        this.add(1.0, a, 1.0, b);
    }

    public void add(DMatrix a, double beta, DMatrix b) {
        this.add(1.0, a, beta, b);
    }

    public void add(double alpha, DMatrix a, double beta, DMatrix b) {
        if (a.getNumRows() != b.getNumRows() || a.getNumCols() != b.getNumCols()) {
            throw new IllegalArgumentException("Matrix dimensions of A and B do not match. A: " + a.getNumRows() + "x" + a.getNumCols() + ", B: " + b.getNumRows() + "x" + b.getNumCols());
        }
        if (a.getNumRows() != this.getNumRows() || a.getNumCols() != this.getNumCols() || b.getNumRows() != this.getNumRows() || b.getNumCols() != this.getNumCols()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. Expected " + this.getNumRows() + "x" + this.getNumCols() + ", was " + a.getNumRows() + "x" + a.getNumCols());
        }
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.unsafe_set(row, col, alpha * a.unsafe_get(row, col) + beta * b.unsafe_get(row, col));
            }
        }
    }

    public void addEquals(DMatrix a) {
        this.addEquals(1.0, a);
    }

    public void addEquals(double alpha, DMatrix a) {
        if (a.getNumRows() != this.getNumRows() || a.getNumCols() != this.getNumCols()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. Expected " + this.getNumRows() + "x" + this.getNumCols() + ", was " + a.getNumRows() + "x" + a.getNumCols());
        }
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.unsafe_set(row, col, this.unsafe_get(row, col) + alpha * a.unsafe_get(row, col));
            }
        }
    }

    public double get(int row, int col) {
        if (col < 0 || col >= this.getNumCols() || row < 0 || row >= this.getNumRows()) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        return this.unsafe_get(row, col);
    }

    public double unsafe_get(int row, int col) {
        return this.variables[row][col].getValue();
    }

    public void getAndReshape(DMatrixD1 matrixToPack) {
        matrixToPack.reshape(this.getNumRows(), this.getNumCols());
        this.get((DMatrix)matrixToPack);
    }

    public void get(DMatrix matrixToPack) {
        if (matrixToPack.getNumRows() != this.getNumRows() || matrixToPack.getNumCols() != this.getNumCols()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. Expected " + this.getNumRows() + "x" + this.getNumCols() + ", was " + matrixToPack.getNumRows() + "x" + matrixToPack.getNumCols());
        }
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int column = 0; column < this.getNumCols(); ++column) {
                matrixToPack.set(row, column, this.unsafe_get(row, column));
            }
        }
    }

    public void set(DMatrix matrix) {
        int numRows = matrix.getNumRows();
        int numCols = matrix.getNumCols();
        if ((numRows > this.maxNumberOfRows || numCols > this.maxNumberOfColumns) && numRows > 0 && numCols > 0) {
            throw new RuntimeException("Not enough rows or columns. matrix to set is " + matrix.getNumRows() + " by " + matrix.getNumCols());
        }
        this.numberOfRows.set(numRows);
        this.numberOfColumns.set(numCols);
        for (int row = 0; row < this.maxNumberOfRows; ++row) {
            for (int column = 0; column < this.maxNumberOfColumns; ++column) {
                double value = row < numRows && column < numCols ? matrix.unsafe_get(row, column) : Double.NaN;
                this.unsafe_set(row, column, value);
            }
        }
    }

    public void reshape(int numRows, int numCols) {
        int col;
        int row;
        if (numRows > this.maxNumberOfRows) {
            throw new IllegalArgumentException("Too many rows. Expected less or equal to " + this.maxNumberOfRows + ", was " + numRows);
        }
        if (numCols > this.maxNumberOfColumns) {
            throw new IllegalArgumentException("Too many columns. Expected less or equal to " + this.maxNumberOfColumns + ", was " + numCols);
        }
        if (numRows < 0 || numCols < 0) {
            throw new IllegalArgumentException("Cannot reshape with a negative number of rows or columns.");
        }
        this.numberOfRows.set(numRows);
        this.numberOfColumns.set(numCols);
        for (row = 0; row < numRows; ++row) {
            for (col = numCols; col < this.maxNumberOfColumns; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
        for (row = numRows; row < this.maxNumberOfRows; ++row) {
            for (col = 0; col < this.maxNumberOfColumns; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
    }

    public void set(int row, int col, double val) {
        if (col < 0 || col >= this.getNumCols() || row < 0 || row >= this.getNumRows()) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        this.unsafe_set(row, col, val);
    }

    public void unsafe_set(int row, int col, double val) {
        this.unsafe_set(row, col, val, true);
    }

    public void unsafe_set(int row, int col, double val, boolean notifyListeners) {
        this.variables[row][col].set(val, notifyListeners);
    }

    public void set(Matrix original) {
        if (original instanceof DMatrix) {
            DMatrix otherMatrix = (DMatrix)original;
            this.reshape(otherMatrix.getNumRows(), otherMatrix.getNumCols());
            for (int row = 0; row < this.getNumRows(); ++row) {
                for (int col = 0; col < this.getNumCols(); ++col) {
                    this.unsafe_set(row, col, otherMatrix.unsafe_get(row, col));
                }
            }
        } else {
            throw new UnsupportedOperationException("Unsupported matrix type: " + original.getClass().getSimpleName());
        }
    }

    public void setToNaN(int numRows, int numCols) {
        this.reshape(numRows, numCols);
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
    }

    public boolean containsNaN() {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                if (!Double.isNaN(this.unsafe_get(row, col))) continue;
                return true;
            }
        }
        return false;
    }

    public void zero() {
        for (int row = 0; row < this.maxNumberOfRows; ++row) {
            for (int col = 0; col < this.maxNumberOfColumns; ++col) {
                if (row < this.getNumRows() && col < this.getNumCols()) {
                    this.unsafe_set(row, col, 0.0);
                    continue;
                }
                this.unsafe_set(row, col, Double.NaN);
            }
        }
    }

    public void zero(int numRows, int numCols) {
        this.reshape(numRows, numCols);
        this.zero();
    }

    public int getNumRows() {
        return this.numberOfRows.getValue();
    }

    public int getNumCols() {
        return this.numberOfColumns.getValue();
    }

    public int getNumElements() {
        return this.getNumRows() * this.getNumCols();
    }

    public YoDouble getYoDouble(int row, int col) {
        return this.variables[row][col];
    }

    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }

    public void print() {
        MatrixIO.printFancy((PrintStream)System.out, (DMatrix)this, (int)11);
    }

    public void print(String format) {
        MatrixIO.print((PrintStream)System.out, (DMatrix)this, (String)format);
    }

    public <T extends Matrix> T createLike() {
        throw new UnsupportedOperationException();
    }

    public <T extends Matrix> T create(int numRows, int numCols) {
        throw new UnsupportedOperationException();
    }

    public <T extends Matrix> T copy() {
        throw new UnsupportedOperationException();
    }

    private static enum NamesProvided {
        NONE,
        ROWS,
        ROWS_AND_COLUMNS;

    }
}

