/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.parameters.YoParameter;

public class ParameterData {
    private final String value;
    private final double min;
    private final double max;

    public ParameterData(String value, String min, String max) {
        this.value = value;
        if (min != null && max != null) {
            this.min = Double.parseDouble(min);
            this.max = Double.parseDouble(max);
        } else {
            this.min = 0.0;
            this.max = 1.0;
        }
    }

    public ParameterData(String value) {
        this.value = value;
        this.min = 0.0;
        this.max = 1.0;
    }

    public void setParameterFromThis(YoParameter parameter) {
        parameter.load(this.value);
        parameter.setParameterBounds(this.min, this.max);
    }

    public String getValue() {
        return this.value;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)1L, (Object)this.value);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.min);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.max);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ParameterData) {
            ParameterData other = (ParameterData)object;
            return this.value.equals(other.value) && this.min == other.min && this.max == other.max;
        }
        return false;
    }

    public String toString() {
        return String.format("[value=%s, min=%s, max=%s]", this.value, Double.toString(this.min), Double.toString(this.max));
    }
}

