/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public abstract class YoMutableFrameTuple2D
extends YoTuple2D
implements FrameTuple2DBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry);
        this.setToZero(referenceFrame);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double x, double y) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, x, y);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double[] tupleArray) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tupleArray);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameTuple2DReadOnly);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry, FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameTuple3DReadOnly);
    }

    public YoMutableFrameTuple2D(String namePrefix, String nameSuffix, YoRegistry registry) {
        super(namePrefix, nameSuffix, registry);
        this.frameId = new YoLong(YoGeometryNameTools.assembleName(namePrefix, "frame", nameSuffix), registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        this.setReferenceFrame(ReferenceFrame.getWorldFrame());
    }

    public YoMutableFrameTuple2D(YoDouble x, YoDouble y, YoLong frameIndex, FrameIndexMap frameIndexMap) {
        super(x, y);
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
    }

    @Override
    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    @Override
    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        YoMutableFrameObject.super.setReferenceFrame(referenceFrame);
    }

    public void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        ReferenceFrame referenceFrame = this.getReferenceFrame();
        if (desiredFrame == referenceFrame) {
            return;
        }
        referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.setReferenceFrame(desiredFrame);
    }

    @Override
    public String toString() {
        return EuclidFrameIOTools.getFrameTuple2DString((FrameTuple2DReadOnly)this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FrameTuple2DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameTuple2DReadOnly)object));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY()), (Object)this.getReferenceFrame());
    }
}

