/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class YoTuple2D
implements Tuple2DBasics {
    private final String namePrefix;
    private final String nameSuffix;
    private final YoDouble x;
    private final YoDouble y;

    public YoTuple2D(YoDouble xVariable, YoDouble yVariable) {
        this.namePrefix = YoGeometryNameTools.getCommonPrefix(xVariable.getName(), yVariable.getName());
        this.nameSuffix = YoGeometryNameTools.getCommonSuffix(xVariable.getName(), yVariable.getName());
        this.x = xVariable;
        this.y = yVariable;
    }

    public YoTuple2D(String namePrefix, YoRegistry registry) {
        this(namePrefix, "", registry);
    }

    public YoTuple2D(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.x = new YoDouble(YoGeometryNameTools.createXName(namePrefix, nameSuffix), registry);
        this.y = new YoDouble(YoGeometryNameTools.createYName(namePrefix, nameSuffix), registry);
    }

    public void setX(double x) {
        this.x.set(x);
    }

    public void setY(double y) {
        this.y.set(y);
    }

    public double getX() {
        return this.x.getDoubleValue();
    }

    public double getY() {
        return this.y.getDoubleValue();
    }

    public final YoDouble getYoX() {
        return this.x;
    }

    public final YoDouble getYoY() {
        return this.y;
    }

    public void notifyVariableChangedListeners() {
        this.x.notifyListeners();
    }

    public final void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.x.addListener(variableChangedListener);
        this.y.addListener(variableChangedListener);
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple2DString((Tuple2DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple2DReadOnly) {
            return this.equals((EuclidGeometry)((Tuple2DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY());
    }
}

