/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoQuaternion
implements QuaternionBasics {
    private final String namePrefix;
    private final String nameSuffix;
    private final YoDouble x;
    private final YoDouble y;
    private final YoDouble z;
    private final YoDouble s;

    public YoQuaternion(YoDouble qxVariable, YoDouble qyVariable, YoDouble qzVariable, YoDouble qsVariable) {
        this.namePrefix = YoGeometryNameTools.getCommonPrefix(qxVariable.getName(), qyVariable.getName(), qzVariable.getName(), qsVariable.getName());
        this.nameSuffix = YoGeometryNameTools.getCommonSuffix(qxVariable.getName(), qyVariable.getName(), qzVariable.getName(), qsVariable.getName());
        this.x = qxVariable;
        this.y = qyVariable;
        this.z = qzVariable;
        this.s = qsVariable;
    }

    public YoQuaternion(String namePrefix, YoRegistry registry) {
        this(namePrefix, "", registry);
    }

    public YoQuaternion(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.x = new YoDouble(YoGeometryNameTools.createQxName(namePrefix, nameSuffix), registry);
        this.y = new YoDouble(YoGeometryNameTools.createQyName(namePrefix, nameSuffix), registry);
        this.z = new YoDouble(YoGeometryNameTools.createQzName(namePrefix, nameSuffix), registry);
        this.s = new YoDouble(YoGeometryNameTools.createQsName(namePrefix, nameSuffix), registry);
        this.s.set(1.0);
    }

    public void setUnsafe(double qx, double qy, double qz, double qs) {
        this.x.set(qx);
        this.y.set(qy);
        this.z.set(qz);
        this.s.set(qs);
    }

    public double getX() {
        return this.x.getDoubleValue();
    }

    public double getY() {
        return this.y.getDoubleValue();
    }

    public double getZ() {
        return this.z.getDoubleValue();
    }

    public double getS() {
        return this.s.getDoubleValue();
    }

    public YoDouble getYoQx() {
        return this.x;
    }

    public YoDouble getYoQy() {
        return this.y;
    }

    public YoDouble getYoQz() {
        return this.z;
    }

    public YoDouble getYoQs() {
        return this.s;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.x.addListener(variableChangedListener);
        this.y.addListener(variableChangedListener);
        this.z.addListener(variableChangedListener);
        this.s.addListener(variableChangedListener);
    }

    public YoQuaternion duplicate(YoRegistry newRegistry) {
        YoDouble x = (YoDouble)newRegistry.findVariable(this.getYoQx().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(this.getYoQy().getFullNameString());
        YoDouble z = (YoDouble)newRegistry.findVariable(this.getYoQz().getFullNameString());
        YoDouble s = (YoDouble)newRegistry.findVariable(this.getYoQs().getFullNameString());
        return new YoQuaternion(x, y, z, s);
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple4DReadOnly) {
            return this.equals((EuclidGeometry)((Tuple4DReadOnly)object));
        }
        return false;
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple4DString((Tuple4DReadOnly)this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)this.getS());
    }
}

