/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoVariableType;

public abstract class YoVariable {
    private final String name;
    private final String description;
    private final YoVariableType type;
    private YoRegistry registry;
    private YoNamespace fullName;
    private List<YoVariableChangedListener> changedListeners;
    private double lowerBound = 0.0;
    private double upperBound = 1.0;

    public YoVariable(YoVariableType type, String name, String description, YoRegistry registry) {
        YoTools.checkForIllegalCharacters(name);
        this.type = type;
        this.name = name;
        this.description = description;
        this.setRegistry(registry);
    }

    public void setRegistry(YoRegistry registry) {
        if (registry == this.registry) {
            return;
        }
        YoRegistry oldRegistry = this.registry;
        this.registry = null;
        if (oldRegistry != null && oldRegistry.hasVariable(this.getName())) {
            oldRegistry.removeVariable(this);
        }
        if (registry != null && !registry.hasVariable(this.getName())) {
            registry.addVariable(this);
        }
        this.registry = registry;
        this.resetFullName();
    }

    public void resetFullName() {
        this.fullName = null;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public YoNamespace getFullName() {
        if (this.fullName == null) {
            this.fullName = this.registry == null ? new YoNamespace(this.name) : this.registry.getNamespace().append(this.name);
        }
        return this.fullName;
    }

    public String getFullNameString() {
        return this.getFullName().getName();
    }

    public YoNamespace getNamespace() {
        return this.registry == null ? null : this.registry.getNamespace();
    }

    public void setVariableBounds(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public final YoVariableType getType() {
        return this.type;
    }

    public void addListener(YoVariableChangedListener listener) {
        if (this.changedListeners == null) {
            this.changedListeners = new ArrayList<YoVariableChangedListener>();
        }
        this.changedListeners.add(listener);
    }

    public void removeListeners() {
        this.changedListeners = null;
    }

    public List<YoVariableChangedListener> getListeners() {
        return this.changedListeners;
    }

    public boolean removeListener(YoVariableChangedListener listener) {
        if (this.changedListeners == null) {
            return false;
        }
        return this.changedListeners.remove(listener);
    }

    public void notifyListeners() {
        if (this.changedListeners != null) {
            for (int i = 0; i < this.changedListeners.size(); ++i) {
                this.changedListeners.get(i).changed(this);
            }
        }
    }

    public abstract double getValueAsDouble();

    public final boolean setValueFromDouble(double value) {
        return this.setValueFromDouble(value, true);
    }

    public abstract boolean setValueFromDouble(double var1, boolean var3);

    public abstract long getValueAsLongBits();

    public final boolean setValueFromLongBits(long value) {
        return this.setValueFromLongBits(value, true);
    }

    public abstract boolean setValueFromLongBits(long var1, boolean var3);

    public abstract boolean setValue(YoVariable var1, boolean var2);

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1);

    public boolean parseValue(String valueAsString) {
        return this.parseValue(valueAsString, true);
    }

    public abstract boolean parseValue(String var1, boolean var2);

    public abstract String convertDoubleValueToString(String var1, double var2);

    public abstract boolean isZero();

    public boolean isParameter() {
        return false;
    }

    public YoParameter getParameter() {
        return null;
    }

    @Deprecated
    public void clear() {
        this.destroy();
    }

    public void destroy() {
        this.setRegistry(null);
        this.changedListeners = null;
    }

    public abstract YoVariable duplicate(YoRegistry var1);

    public abstract String toString();
}

