/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.Arrays;
import us.ihmc.yoVariables.providers.EnumProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoEnum<E extends Enum<E>>
extends YoVariable
implements EnumProvider<E> {
    public static final int NULL_VALUE = -1;
    public static final String NULL_VALUE_STRING = "null";
    private final Class<E> enumType;
    private final boolean allowNullValue;
    private final E[] enumValues;
    private final String[] enumValuesAsString;
    private int valueOrdinal;

    public YoEnum(String name, YoRegistry registry, Class<E> enumType) {
        this(name, "", registry, enumType, false);
    }

    public YoEnum(String name, YoRegistry registry, Class<E> enumType, boolean allowNullValue) {
        this(name, "", registry, enumType, allowNullValue);
    }

    public YoEnum(String name, String description, YoRegistry registry, Class<E> enumType, boolean allowNullValue) {
        super(YoVariableType.ENUM, name, description, registry);
        this.enumType = enumType;
        this.allowNullValue = allowNullValue;
        this.enumValues = (Enum[])enumType.getEnumConstants();
        this.enumValuesAsString = new String[this.enumValues.length];
        for (int i = 0; i < this.enumValues.length; ++i) {
            String enumValueAsString = ((Enum)this.enumValues[i]).toString();
            if (enumValueAsString.equalsIgnoreCase(NULL_VALUE_STRING)) {
                throw new IllegalArgumentException(enumValueAsString + " is a restricted keyword. No enum constants named \"null\"(case insensitive) are allowed.");
            }
            this.enumValuesAsString[i] = enumValueAsString;
        }
        if (!allowNullValue && this.enumValues.length == 0) {
            throw new IllegalArgumentException("Cannot initialize an enum variable with zero elements if allowNullValue is false.");
        }
        if (allowNullValue || this.enumValues.length == 0) {
            this.set(-1);
        } else {
            this.set(0);
        }
        this.setVariableBounds(allowNullValue ? -1.0 : 0.0, this.enumValues.length - 1);
    }

    public YoEnum(String name, String description, YoRegistry registry, boolean allowNullValue, String ... constants) {
        super(YoVariableType.ENUM, name, description, registry);
        this.enumType = null;
        this.allowNullValue = allowNullValue;
        this.enumValues = null;
        for (String constant : constants) {
            if (constant == null) {
                throw new IllegalArgumentException("One of the enum constants is null.");
            }
            if (!constant.equalsIgnoreCase(NULL_VALUE_STRING)) continue;
            throw new IllegalArgumentException(constant + " is a restricted keyword. No enum constants named \"null\"(case insensitive) are allowed.");
        }
        this.enumValuesAsString = Arrays.copyOf(constants, constants.length);
        if (!allowNullValue && constants.length == 0) {
            throw new IllegalArgumentException("Cannot initialize an enum variable with zero elements if allowNullValue is false.");
        }
        if (allowNullValue || constants.length == 0) {
            this.set(-1);
        } else {
            this.set(0);
        }
        this.setVariableBounds(allowNullValue ? -1.0 : 0.0, constants.length - 1);
    }

    public boolean isBackedByEnum() {
        return this.enumType != null;
    }

    public boolean isNullAllowed() {
        return this.allowNullValue;
    }

    private void checkIfBackedByEnum() {
        if (this.enumType == null) {
            throw new UnsupportedOperationException("This YoEnum is not backed by an Enum type.");
        }
    }

    public boolean valueEquals(E value) {
        this.checkIfBackedByEnum();
        if (this.valueOrdinal == -1) {
            return value == null;
        }
        return ((Enum)value).ordinal() == this.valueOrdinal;
    }

    public Class<E> getEnumType() {
        this.checkIfBackedByEnum();
        return this.enumType;
    }

    public E[] getEnumValues() {
        this.checkIfBackedByEnum();
        return this.enumValues;
    }

    public String[] getEnumValuesAsString() {
        return this.enumValuesAsString;
    }

    @Override
    public E getValue() {
        return this.getEnumValue();
    }

    public E getEnumValue() {
        this.checkIfBackedByEnum();
        return this.valueOrdinal == -1 ? null : (E)this.enumValues[this.valueOrdinal];
    }

    public boolean set(E value) {
        return this.set(value, true);
    }

    public boolean set(E value, boolean notifyListeners) {
        this.checkIfBackedByEnum();
        if (!this.allowNullValue && value == null) {
            throw new IllegalArgumentException("Setting YoEnum " + this.getName() + " to null. Must set allowNullValue to true in the constructor if you ever want to set it to null.");
        }
        return this.set(value == null ? -1 : ((Enum)value).ordinal(), notifyListeners);
    }

    public int getOrdinal() {
        return this.valueOrdinal;
    }

    public boolean set(int ordinal) {
        return this.set(ordinal, true);
    }

    public boolean set(int ordinal, boolean notifyListeners) {
        this.checkBounds(ordinal);
        if (this.valueOrdinal != ordinal) {
            this.valueOrdinal = ordinal;
            if (notifyListeners) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private void checkBounds(int ordinal) {
        if (ordinal < 0 && (!this.allowNullValue || ordinal != -1) || ordinal >= this.enumValuesAsString.length) {
            throw new RuntimeException("Enum constant associated with value " + ordinal + " not present. VariableName = " + this.getFullNameString());
        }
    }

    public String getStringValue() {
        if (this.valueOrdinal == -1) {
            return NULL_VALUE_STRING;
        }
        return this.enumValuesAsString[this.valueOrdinal];
    }

    @Override
    public boolean setValueFromDouble(double value, boolean notifyListeners) {
        int ordinal = (int)Math.round(value);
        ordinal = Math.min(ordinal, this.getEnumSize() - 1);
        ordinal = Math.max(ordinal, this.allowNullValue ? -1 : 0);
        return this.set(ordinal, notifyListeners);
    }

    @Override
    public double getValueAsDouble() {
        return this.valueOrdinal;
    }

    @Override
    public long getValueAsLongBits() {
        return this.valueOrdinal;
    }

    @Override
    public boolean setValueFromLongBits(long value, boolean notifyListeners) {
        return this.set((int)value, notifyListeners);
    }

    @Override
    public boolean setValue(YoVariable other, boolean notifyListeners) {
        YoEnum otherEnum = (YoEnum)other;
        if (otherEnum.isBackedByEnum() && this.isBackedByEnum()) {
            return this.set(otherEnum.getEnumValue(), notifyListeners);
        }
        return this.set(otherEnum.getOrdinal(), notifyListeners);
    }

    public int getEnumSize() {
        return this.enumValuesAsString.length;
    }

    @Override
    public String getValueAsString(String format) {
        return this.getStringValue();
    }

    @Override
    public boolean parseValue(String valueAsString, boolean notifyListeners) {
        if (valueAsString.toLowerCase().equals(NULL_VALUE_STRING)) {
            return this.set(-1, notifyListeners);
        }
        for (int i = 0; i < this.enumValuesAsString.length; ++i) {
            if (!valueAsString.equals(this.enumValuesAsString[i])) continue;
            return this.set(i, notifyListeners);
        }
        throw new IllegalArgumentException("Unable to parse value for parameter: " + this.getFullNameString() + ". String value: " + valueAsString);
    }

    @Override
    public String convertDoubleValueToString(String format, double value) {
        int ordinal = (int)Math.round(value);
        ordinal = Math.min(ordinal, this.getEnumSize() - 1);
        if ((ordinal = Math.max(ordinal, this.allowNullValue ? -1 : 0)) == -1) {
            return NULL_VALUE_STRING;
        }
        return this.enumValuesAsString[ordinal];
    }

    @Override
    public boolean isZero() {
        return this.getEnumValue() == null;
    }

    @Override
    public YoEnum<E> duplicate(YoRegistry newRegistry) {
        YoEnum<E> duplicate = this.isBackedByEnum() ? new YoEnum<E>(this.getName(), this.getDescription(), newRegistry, this.getEnumType(), this.isNullAllowed()) : new YoEnum<E>(this.getName(), this.getDescription(), newRegistry, this.isNullAllowed(), this.getEnumValuesAsString());
        duplicate.set(this.getOrdinal());
        return duplicate;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getName(), this.getStringValue());
    }
}

