/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoBoolean
extends YoVariable
implements BooleanProvider {
    private boolean value;

    public YoBoolean(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public YoBoolean(String name, String description, YoRegistry registry) {
        super(YoVariableType.BOOLEAN, name, description, registry);
        this.set(false);
    }

    public boolean valueEquals(boolean value) {
        return this.value == value;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public boolean set(boolean value) {
        return this.set(value, true);
    }

    public boolean set(boolean value, boolean notifyListeners) {
        if (this.value != value) {
            this.value = value;
            if (notifyListeners) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getValueAsDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public boolean setValueFromDouble(double value, boolean notifyListeners) {
        return this.set(value >= 0.5, notifyListeners);
    }

    @Override
    public long getValueAsLongBits() {
        return this.value ? 1L : 0L;
    }

    @Override
    public boolean setValueFromLongBits(long value, boolean notifyListeners) {
        return this.set(value == 1L, notifyListeners);
    }

    @Override
    public boolean setValue(YoVariable other, boolean notifyListeners) {
        return this.set(((YoBoolean)other).getValue(), notifyListeners);
    }

    @Override
    public String getValueAsString(String format) {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean parseValue(String valueAsString, boolean notifyListeners) {
        return this.set(Boolean.parseBoolean(valueAsString), notifyListeners);
    }

    @Override
    public String convertDoubleValueToString(String format, double value) {
        return Boolean.toString(value >= 0.5);
    }

    @Override
    public boolean isZero() {
        return !this.value;
    }

    @Override
    public YoBoolean duplicate(YoRegistry newRegistry) {
        YoBoolean duplicate = new YoBoolean(this.getName(), this.getDescription(), newRegistry);
        duplicate.set(this.value);
        return duplicate;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getName(), this.value);
    }
}

