/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.yoVariables.exceptions.IllegalNameException;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoSearchTools;

public class YoTools {
    private static final boolean ALLOW_REPEATING_SUBNAMES = "true".equalsIgnoreCase(System.getProperty("yo.allowRepeatingSubname"));
    public static final char NAMESPACE_SEPERATOR = '.';
    public static final String NAMESPACE_SEPERATOR_STRING = Character.toString('.');
    public static final String NAMESPACE_SEPERATOR_REGEX = Pattern.quote(NAMESPACE_SEPERATOR_STRING);
    public static final String ILLEGAL_CHARACTERS_REGEX = "[ `~.*!?@#$%/^&()<>,:;{}'\"\\\\=+|]";
    public static final Pattern ILLEGAL_CHARACTERS_PATTERN = Pattern.compile("[ `~.*!?@#$%/^&()<>,:;{}'\"\\\\=+|]");

    public static void checkForIllegalCharacters(String name) {
        if (ILLEGAL_CHARACTERS_PATTERN.matcher(name).find()) {
            String message = name + " contains at least one illegal character. Illegal characters: [ `~.*!?@#$%/^&()<>,:;{}'\"\\\\=+|]";
            throw new IllegalNameException(message);
        }
    }

    public static void printStatistics(int minVariablesToPrint, int minChildrenToPrint, YoRegistry root) {
        YoTools.printStatistics(minVariablesToPrint, minChildrenToPrint, root, YoTools::getRegistryInfo, System.out);
    }

    public static void printStatistics(int minVariablesToPrint, int minChildrenToPrint, YoRegistry root, Function<YoRegistry, String> registryInfoFunction, PrintStream printStream) {
        YoTools.printStatistics(candidate -> candidate.getVariables().size() >= minVariablesToPrint || candidate.getChildren().size() >= minChildrenToPrint, root, registryInfoFunction, printStream);
    }

    public static void printStatistics(Predicate<YoRegistry> filter, YoRegistry root, Function<YoRegistry, String> registryInfoFunction, PrintStream printStream) {
        List<YoRegistry> registriesOfInterest = YoSearchTools.filterRegistries(filter, root);
        Collections.sort(registriesOfInterest, (o1, o2) -> Integer.compare(o2.getNumberOfVariables(), o1.getNumberOfVariables()));
        printStream.println(YoTools.class.getSimpleName() + ": Printing descendants of " + root.getName() + " registry.");
        printStream.println("Total number of variables: " + root.getNumberOfVariablesDeep());
        printStream.println("Sorting by number of variables.");
        registriesOfInterest.forEach(registry -> printStream.println((String)registryInfoFunction.apply((YoRegistry)registry)));
    }

    public static String getRegistryInfo(YoRegistry registry) {
        int maxNameLength = 70;
        return YoTools.getRegistryInfo(registry, maxNameLength);
    }

    public static String getRegistryInfo(YoRegistry registry, int maxNameLength) {
        int variables = registry.getNumberOfVariables();
        int children = registry.getChildren().size();
        int maxPropertyLength = 17;
        String variableString = YoTools.trimOrPadToLength("Variables: " + variables, maxPropertyLength, "...");
        String childrenString = YoTools.trimOrPadToLength("Children: " + children, maxPropertyLength, "...");
        Object name = registry.getClass().getSimpleName() + " " + registry.getNamespace().getName();
        name = YoTools.trimOrPadToLength((String)name, maxNameLength, "...");
        return (String)name + "\t" + variableString + "\t" + childrenString;
    }

    private static String trimOrPadToLength(String original, int length, String placeholder) {
        int chararcters = original.length();
        int placeholderLength = placeholder.length();
        if (chararcters > length) {
            return original.substring(0, length - placeholderLength) + placeholder;
        }
        return StringUtils.rightPad((String)original, (int)length, (String)" ");
    }

    public static List<String> splitName(String name) {
        return Arrays.asList(name.split(NAMESPACE_SEPERATOR_REGEX, -1));
    }

    public static String toShortName(String name) {
        int separatorIndex = name.lastIndexOf(NAMESPACE_SEPERATOR_STRING);
        if (separatorIndex == -1) {
            return name;
        }
        return name.substring(separatorIndex + 1);
    }

    public static String joinNames(List<String> subNames) {
        return String.join((CharSequence)NAMESPACE_SEPERATOR_STRING, subNames);
    }

    public static void checkNameDoesNotContainSeparator(String name) {
        if (name.contains(NAMESPACE_SEPERATOR_STRING)) {
            throw new IllegalNameException("The name cannot contain '" + NAMESPACE_SEPERATOR_STRING + "'. Was: " + name);
        }
    }

    public static void checkNamespaceSanity(YoNamespace namespace) {
        if (namespace.getSubNames().stream().anyMatch(subName -> subName.isEmpty())) {
            throw new IllegalNameException("The namespace has 1+ empty subname.\nNamespace: " + namespace.getName());
        }
        if (namespace.getSubNames().stream().anyMatch(subName -> subName.contains(NAMESPACE_SEPERATOR_REGEX))) {
            throw new IllegalNameException("A sub-name can not contain the seperator string '.'.");
        }
        if (!YoTools.joinNames(namespace.getSubNames()).equals(namespace.getName())) {
            throw new IllegalNameException("The namespace has inconsistent sub-names.\nNamespace: " + namespace.getName() + "\nSub-names: " + YoTools.joinNames(namespace.getSubNames()));
        }
        if (!ALLOW_REPEATING_SUBNAMES && new HashSet<String>(namespace.getSubNames()).size() != namespace.size()) {
            throw new IllegalNameException("The namespace has duplicate sub-names.\nNamespace: " + namespace.getName());
        }
    }

    public static YoNamespace concatenate(YoNamespace namespaceA, YoNamespace namespaceB) {
        ArrayList<String> subNames = new ArrayList<String>(namespaceA.size() + namespaceB.size());
        subNames.addAll(namespaceA.getSubNames());
        subNames.addAll(namespaceB.getSubNames());
        return new YoNamespace(subNames);
    }

    public static YoNamespace concatenate(YoNamespace namespace, String name) {
        List<String> splitName = YoTools.splitName(name);
        ArrayList<String> subNames = new ArrayList<String>(namespace.size() + splitName.size());
        subNames.addAll(namespace.getSubNames());
        subNames.addAll(splitName);
        return new YoNamespace(subNames);
    }

    public static YoNamespace concatenate(String name, YoNamespace namespace) {
        List<String> splitName = YoTools.splitName(name);
        ArrayList<String> subNames = new ArrayList<String>(splitName.size() + namespace.size());
        subNames.addAll(splitName);
        subNames.addAll(namespace.getSubNames());
        return new YoNamespace(subNames);
    }

    public static YoNamespace concatenate(String nameA, String nameB) {
        List<String> splitNameA = YoTools.splitName(nameA);
        List<String> splitNameB = YoTools.splitName(nameB);
        ArrayList<String> subNames = new ArrayList<String>(splitNameA.size() + splitNameB.size());
        subNames.addAll(splitNameA);
        subNames.addAll(splitNameB);
        return new YoNamespace(subNames);
    }
}

