/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.tools;

import org.apache.commons.lang3.StringUtils;

public class YoGeometryNameTools {
    public static String getCommonPrefix(String ... strings) {
        return StringUtils.getCommonPrefix((String[])strings);
    }

    public static String getCommonSuffix(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        String[] reversedStrs = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            reversedStrs[i] = StringUtils.reverse((String)strings[i]);
        }
        return StringUtils.reverse((String)StringUtils.getCommonPrefix((String[])reversedStrs));
    }

    public static String createXName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "x", nameSuffix);
    }

    public static String createYName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "y", nameSuffix);
    }

    public static String createZName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "z", nameSuffix);
    }

    public static String createQxName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "qx", nameSuffix);
    }

    public static String createQyName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "qy", nameSuffix);
    }

    public static String createQzName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "qz", nameSuffix);
    }

    public static String createQsName(String namePrefix, String nameSuffix) {
        return YoGeometryNameTools.assembleName(namePrefix, "qs", nameSuffix);
    }

    public static String assembleName(String ... subNames) {
        if (subNames == null || subNames.length == 0) {
            return null;
        }
        String name = subNames[0];
        for (int i = 1; i < subNames.length; ++i) {
            name = YoGeometryNameTools.appendSuffix(name, subNames[i]);
        }
        return name;
    }

    public static String appendSuffix(String name, String suffix) {
        if (name == null || name.isEmpty()) {
            return StringUtils.uncapitalize((String)suffix);
        }
        if (suffix == null || suffix.isEmpty()) {
            return name;
        }
        if (name.endsWith("_")) {
            return name + StringUtils.uncapitalize((String)suffix);
        }
        return name + StringUtils.capitalize((String)suffix);
    }
}

