/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.tools;

import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFactories {
    public static YoRegistry findOrCreateRegistry(YoRegistry startRegistry, YoNamespace fullNamespace) {
        YoNamespace namespace = startRegistry.getNamespace();
        if (namespace.equals(fullNamespace)) {
            return startRegistry;
        }
        if (!fullNamespace.startsWith(namespace)) {
            return null;
        }
        for (YoRegistry child : startRegistry.getChildren()) {
            YoRegistry registry = YoFactories.findOrCreateRegistry(child, fullNamespace);
            if (registry == null) continue;
            return registry;
        }
        YoNamespace namespaceToContinueWith = fullNamespace.removeStart(namespace);
        YoRegistry registry = YoFactories.createChainOfRegistries(namespaceToContinueWith);
        startRegistry.addChild(registry);
        return YoFactories.getToBottomRegistry(registry);
    }

    public static YoRegistry createChainOfRegistries(YoNamespace fullNamespace) {
        YoRegistry rootRegistry;
        YoRegistry current = rootRegistry = new YoRegistry(fullNamespace.getRootName());
        for (int i = 1; i < fullNamespace.size(); ++i) {
            YoRegistry child = new YoRegistry(fullNamespace.getSubName(i));
            current.addChild(child);
            current = child;
        }
        return rootRegistry;
    }

    private static YoRegistry getToBottomRegistry(YoRegistry root) {
        if (root.getChildren().size() == 0) {
            return root;
        }
        if (root.getChildren().size() > 1) {
            throw new RuntimeException("This should only be called with a new chain!!");
        }
        return YoFactories.getToBottomRegistry(root.getChildren().get(0));
    }
}

