/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.exceptions.NameCollisionException;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistryRestrictionLevel;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoRegistry
implements YoVariableHolder {
    private final String name;
    private YoNamespace namespace;
    private final List<YoVariable> variables = new ArrayList<YoVariable>();
    private final Map<String, YoVariable> nameToVariableMap = new LinkedHashMap<String, YoVariable>();
    private final List<YoParameter> parameters = new ArrayList<YoParameter>();
    private YoRegistry parent;
    private final List<YoRegistry> children = new ArrayList<YoRegistry>();
    private final Map<String, YoRegistry> nameToChildMap = new LinkedHashMap<String, YoRegistry>();
    private List<YoRegistryChangedListener> changedListeners;
    private YoRegistryRestrictionLevel restrictionLevel = YoRegistryRestrictionLevel.FULLY_MUTABLE;

    public YoRegistry(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a registry without a name.");
        }
        YoTools.checkForIllegalCharacters(name);
        this.name = name;
        this.namespace = new YoNamespace(name);
    }

    public String getName() {
        return this.name;
    }

    public YoNamespace getNamespace() {
        return this.namespace;
    }

    public void setRestrictionLevel(YoRegistryRestrictionLevel restrictionLevel) {
        if (this.restrictionLevel.ordinal() > restrictionLevel.ordinal()) {
            throw new IllegalArgumentException("Cannot reduce restriction level. Current mode: " + restrictionLevel + ", tried to set to: " + restrictionLevel);
        }
        this.restrictionLevel = restrictionLevel;
        for (int i = 0; i < this.children.size(); ++i) {
            YoRegistry child = this.children.get(i);
            if (child.restrictionLevel.ordinal() >= restrictionLevel.ordinal()) continue;
            child.setRestrictionLevel(restrictionLevel);
        }
    }

    public YoRegistryRestrictionLevel getRestrictionLevel() {
        return this.restrictionLevel;
    }

    @Deprecated
    public void clear() {
        this.destroy();
    }

    public void destroy() {
        if (!this.isRoot() && this.restrictionLevel != YoRegistryRestrictionLevel.FULLY_MUTABLE) {
            throw new IllegalOperationException("Cannot clear a registry that is not the root and that does not have appropriate restriction level.");
        }
        this.detachFromParent();
        this.destroyInternal(false);
        this.notifyListeners(null, null, null, ChangeType.CLEARED);
        this.changedListeners = null;
    }

    private void destroyInternal(boolean clearListeners) {
        for (int i = this.variables.size() - 1; i >= 0; --i) {
            this.variables.get(i).destroy();
        }
        this.nameToVariableMap.clear();
        this.parameters.clear();
        this.children.forEach(child -> child.destroyInternal(true));
        this.children.clear();
        this.nameToChildMap.clear();
        this.restrictionLevel = YoRegistryRestrictionLevel.FULLY_MUTABLE;
        if (clearListeners) {
            this.changedListeners = null;
        }
    }

    public void addListener(YoRegistryChangedListener listener) {
        if (this.changedListeners == null) {
            this.changedListeners = new ArrayList<YoRegistryChangedListener>();
        }
        this.changedListeners.add(listener);
    }

    public void removeListeners() {
        this.changedListeners = null;
    }

    public boolean removeListener(YoRegistryChangedListener listener) {
        if (this.changedListeners == null) {
            return false;
        }
        return this.changedListeners.remove(listener);
    }

    public void addVariable(YoVariable variable) {
        if (!this.restrictionLevel.isAdditionAllowed()) {
            throw new IllegalOperationException("Cannot add variables to this registry: " + this.namespace);
        }
        if (this.nameToVariableMap.containsValue(variable)) {
            return;
        }
        String variableName = variable.getName().toLowerCase();
        if (this.nameToVariableMap.containsKey(variableName)) {
            throw new NameCollisionException("Name collision for new variable: " + variableName + ". Parent name space = " + this.getNamespace());
        }
        if (variable.getRegistry() != null) {
            variable.getRegistry().removeVariable(variable);
        }
        this.variables.add(variable);
        this.nameToVariableMap.put(variableName, variable);
        variable.setRegistry(this);
        if (variable.isParameter()) {
            this.parameters.add(variable.getParameter());
        }
        this.notifyListeners(this, null, variable, ChangeType.VARIABLE_ADDED);
    }

    public void removeVariable(YoVariable variable) {
        if (!this.nameToVariableMap.containsValue(variable)) {
            return;
        }
        String variableName = variable.getName().toLowerCase();
        if (!this.restrictionLevel.isRemovalAllowed()) {
            throw new IllegalOperationException("Cannot remove variables from this registry: " + this.namespace);
        }
        variable.setRegistry(null);
        this.variables.remove(variable);
        this.nameToVariableMap.remove(variableName);
        if (variable.isParameter()) {
            this.parameters.remove(variable.getParameter());
        }
        this.notifyListeners(this, null, variable, ChangeType.VARIABLE_REMOVED);
    }

    public void addChild(YoRegistry child) {
        this.addChild(child, true);
    }

    public void addChild(YoRegistry child, boolean notifyListeners) {
        if (child == null) {
            return;
        }
        if (child == this) {
            throw new IllegalOperationException("Cannot register a registry as a child of itself, registry: " + this.namespace);
        }
        if (!this.restrictionLevel.isAdditionAllowed()) {
            throw new IllegalOperationException("Cannot add children to this registry: " + this.namespace);
        }
        if (this.nameToChildMap.containsValue(child)) {
            return;
        }
        String childName = child.getName().toLowerCase();
        if (this.nameToChildMap.containsKey(childName)) {
            throw new NameCollisionException("Name collision for new child: " + childName + ". Parent name space = " + this.getNamespace());
        }
        child.detachFromParent();
        child.parent = this;
        child.setParentNamespace(this.namespace);
        if (child.getRestrictionLevel().ordinal() < this.restrictionLevel.ordinal()) {
            child.setRestrictionLevel(this.restrictionLevel);
        }
        this.children.add(child);
        this.nameToChildMap.put(childName, child);
        if (notifyListeners) {
            this.notifyListeners(this, child, null, ChangeType.REGISTRY_ADDED);
        }
    }

    public void removeChild(YoRegistry child) {
        if (child == null || child.getParent() != this) {
            return;
        }
        if (!this.restrictionLevel.isRemovalAllowed()) {
            throw new IllegalOperationException("Cannot remove children from this registry: " + this.namespace);
        }
        String childName = child.getName().toLowerCase();
        child.parent = null;
        child.setParentNamespace(null);
        this.children.remove(child);
        this.nameToChildMap.remove(childName);
        this.notifyListeners(this, child, null, ChangeType.REGISTRY_REMOVED);
    }

    public void detachFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.removeChild(this);
    }

    private void setParentNamespace(YoNamespace parentNamespace) {
        this.namespace = parentNamespace == null ? new YoNamespace(this.name) : parentNamespace.append(this.name);
        this.namespace.checkSanity();
        this.children.forEach(child -> child.setParentNamespace(this.namespace));
        this.variables.forEach(variable -> variable.resetFullName());
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean hasParametersDeep() {
        if (this.hasParameters()) {
            return true;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).hasParametersDeep()) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public YoRegistry getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.parent.getRoot();
    }

    public YoRegistry getParent() {
        return this.parent;
    }

    public YoRegistry getChild(String name) {
        return this.nameToChildMap.get(name.toLowerCase());
    }

    public List<YoRegistry> getChildren() {
        return this.children;
    }

    public YoVariable getVariable(String name) {
        return this.nameToVariableMap.get(name.toLowerCase());
    }

    @Override
    public List<YoVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public YoParameter getParameter(String name) {
        YoVariable yoVariable = this.getVariable(name);
        if (yoVariable != null && yoVariable.isParameter()) {
            return yoVariable.getParameter();
        }
        return null;
    }

    public List<YoParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<YoVariable> collectSubtreeVariables() {
        ArrayList<YoVariable> yoVariables = new ArrayList<YoVariable>();
        this.collectSubtreeVariables(yoVariables);
        return yoVariables;
    }

    private void collectSubtreeVariables(List<YoVariable> variablesToPack) {
        variablesToPack.addAll(this.variables);
        for (YoRegistry child : this.children) {
            child.collectSubtreeVariables(variablesToPack);
        }
    }

    public List<YoParameter> collectSubtreeParameters() {
        ArrayList<YoParameter> yoParameters = new ArrayList<YoParameter>();
        this.collectSubtreeParameters(yoParameters);
        return yoParameters;
    }

    private void collectSubtreeParameters(List<YoParameter> parametersToPack) {
        parametersToPack.addAll(this.parameters);
        for (YoRegistry child : this.children) {
            child.collectSubtreeParameters(parametersToPack);
        }
    }

    public List<YoRegistry> collectSubtreeRegistries() {
        ArrayList<YoRegistry> yoVariableRegistries = new ArrayList<YoRegistry>();
        this.collectSubtreeRegistries(yoVariableRegistries);
        return yoVariableRegistries;
    }

    public void collectSubtreeRegistries(List<YoRegistry> yoVariableRegistriesToPack) {
        yoVariableRegistriesToPack.add(this);
        for (YoRegistry child : this.children) {
            child.collectSubtreeRegistries(yoVariableRegistriesToPack);
        }
    }

    @Override
    public YoVariable findVariable(String name) {
        return YoVariableHolder.super.findVariable(name);
    }

    @Override
    public YoVariable findVariable(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return YoSearchTools.findFirstVariable(namespaceEnding, name, null, this);
    }

    @Override
    public List<YoVariable> findVariables(String name) {
        return YoVariableHolder.super.findVariables(name);
    }

    @Override
    public List<YoVariable> findVariables(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return YoSearchTools.findVariables(namespaceEnding, name, null, this, null);
    }

    @Override
    public List<YoVariable> findVariables(YoNamespace namespace) {
        YoRegistry registry = this.findRegistry(namespace);
        if (registry == null) {
            return Collections.emptyList();
        }
        return registry.getVariables();
    }

    public YoRegistry findRegistry(String name) {
        int separatorIndex = name.lastIndexOf(YoTools.NAMESPACE_SEPERATOR_STRING);
        if (separatorIndex == -1) {
            return this.findRegistry(null, name);
        }
        return this.findRegistry(name.substring(0, separatorIndex), name.substring(separatorIndex + 1));
    }

    public YoRegistry findRegistry(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return YoSearchTools.findFirstRegistry(namespaceEnding, name, null, this);
    }

    public YoRegistry findRegistry(YoNamespace namespaceEnding) {
        if (this.namespace.endsWith(namespaceEnding)) {
            return this;
        }
        for (YoRegistry child : this.children) {
            YoRegistry registry = child.findRegistry(namespaceEnding);
            if (registry == null) continue;
            return registry;
        }
        return null;
    }

    @Override
    public boolean hasUniqueVariable(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return this.countNumberOfVariables(namespaceEnding, name) == 1;
    }

    private int countNumberOfVariables(String parentNamespace, String name) {
        int count = 0;
        if ((parentNamespace == null || this.namespace.endsWith(parentNamespace)) && this.nameToVariableMap.containsKey(name.toLowerCase())) {
            ++count;
        }
        for (YoRegistry child : this.children) {
            count += child.countNumberOfVariables(parentNamespace, name);
        }
        return count;
    }

    public int getNumberOfVariables() {
        return this.variables.size();
    }

    public int getNumberOfVariablesDeep() {
        int numberOfVariables = this.variables.size();
        for (int i = 0; i < this.children.size(); ++i) {
            numberOfVariables += this.children.get(i).getNumberOfVariablesDeep();
        }
        return numberOfVariables;
    }

    public YoVariable getVariable(int index) {
        return this.variables.get(index);
    }

    private void notifyListeners(YoRegistry targetParentRegistry, YoRegistry targetRegistry, YoVariable targetVariable, ChangeType type) {
        if (this.changedListeners != null) {
            RegistryChange change = new RegistryChange(targetParentRegistry, targetRegistry, targetVariable, type);
            for (YoRegistryChangedListener listener : this.changedListeners) {
                listener.changed(change);
            }
        }
        if (this.parent != null) {
            this.parent.notifyListeners(targetParentRegistry, targetRegistry, targetVariable, type);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof YoRegistry)) {
            return false;
        }
        YoRegistry other = (YoRegistry)object;
        if (!this.getNamespace().equals(other.getNamespace())) {
            return false;
        }
        if (this.variables.size() != other.variables.size()) {
            return false;
        }
        for (YoVariable variable : this.variables) {
            if (other.nameToVariableMap.containsKey(variable.getName().toLowerCase())) continue;
            return false;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        for (YoRegistry child : this.children) {
            if (other.nameToChildMap.containsKey(child.getName().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public String toString() {
        return this.namespace.getName();
    }

    private static enum ChangeType {
        REGISTRY_ADDED,
        REGISTRY_REMOVED,
        VARIABLE_ADDED,
        VARIABLE_REMOVED,
        CLEARED;

    }

    private final class RegistryChange
    implements YoRegistryChangedListener.Change {
        private final YoRegistry targetParentRegistry;
        private final YoRegistry targetRegistry;
        private final YoVariable targetVariable;
        private final ChangeType type;

        public RegistryChange(YoRegistry targetParentRegistry, YoRegistry targetRegistry, YoVariable targetVariable, ChangeType type) {
            this.targetParentRegistry = targetParentRegistry;
            this.targetRegistry = targetRegistry;
            this.targetVariable = targetVariable;
            this.type = type;
        }

        @Override
        public boolean wasRegistryAdded() {
            return this.type == ChangeType.REGISTRY_ADDED;
        }

        @Override
        public boolean wasRegistryRemoved() {
            return this.type == ChangeType.REGISTRY_REMOVED;
        }

        @Override
        public boolean wasVariableAdded() {
            return this.type == ChangeType.VARIABLE_ADDED;
        }

        @Override
        public boolean wasVariableRemoved() {
            return this.type == ChangeType.VARIABLE_REMOVED;
        }

        @Override
        public boolean wasCleared() {
            return this.type == ChangeType.CLEARED;
        }

        @Override
        public YoRegistry getSource() {
            return YoRegistry.this;
        }

        @Override
        public YoRegistry getTargetParentRegistry() {
            return this.targetParentRegistry;
        }

        @Override
        public YoRegistry getTargetRegistry() {
            return this.targetRegistry;
        }

        @Override
        public YoVariable getTargetVariable() {
            return this.targetVariable;
        }

        public String toString() {
            switch (this.type) {
                case REGISTRY_ADDED: {
                    return String.format("Added registry: %s. Child of: %s. Source of event: %s", this.targetRegistry.getName(), this.targetParentRegistry.getName(), YoRegistry.this.getName());
                }
                case REGISTRY_REMOVED: {
                    return String.format("Removed registry: %s. Was child of: %s. Source of event: %s", this.targetRegistry.getName(), this.targetParentRegistry.getName(), YoRegistry.this.getName());
                }
                case VARIABLE_ADDED: {
                    return String.format("Added variable: %s. Registered in: %s. Source of event: %s", this.targetVariable.getName(), this.targetParentRegistry.getName(), YoRegistry.this.getName());
                }
                case VARIABLE_REMOVED: {
                    return String.format("Removed variable: %s. Was registered in: %s. Source of event: %s", this.targetVariable.getName(), this.targetParentRegistry.getName(), YoRegistry.this.getName());
                }
                case CLEARED: {
                    return String.format("Cleared registry: %s.", YoRegistry.this.getName());
                }
            }
            return "Unexpected event type: " + this.type;
        }
    }
}

