/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.yoVariables.tools.YoTools;

public class YoNamespace
implements Serializable {
    private static final long serialVersionUID = -2584260031738121095L;
    private final String name;
    private final List<String> subNames;

    public YoNamespace(List<String> subNames) {
        if (subNames == null || subNames.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty namespace.");
        }
        this.name = YoTools.joinNames(subNames);
        this.subNames = subNames;
    }

    public YoNamespace(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty namespace.");
        }
        this.name = name;
        this.subNames = YoTools.splitName(name);
        for (String subName : this.subNames) {
            if (!subName.isEmpty()) continue;
            throw new IllegalArgumentException("Cannot create a namespace with empty sub-names: " + this.subNames);
        }
    }

    public void checkSanity() {
        YoTools.checkNamespaceSanity(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.subNames.size() == 1;
    }

    public String getRootName() {
        return this.subNames.get(0);
    }

    public String getShortName() {
        return this.subNames.get(this.size() - 1);
    }

    public List<String> getSubNames() {
        return Collections.unmodifiableList(this.subNames);
    }

    public int size() {
        return this.subNames.size();
    }

    public String getSubName(int index) {
        return this.subNames.get(index);
    }

    public YoNamespace getParent() {
        return this.removeEnd(1);
    }

    public YoNamespace subNamespace(int fromIndex) {
        return this.subNamespace(fromIndex, this.size());
    }

    public YoNamespace subNamespace(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return new YoNamespace(this.subNames.subList(fromIndex, toIndex));
    }

    public YoNamespace removeStart(int length) {
        if (length < 0 || length > this.size()) {
            throw new IndexOutOfBoundsException("Invalid length: " + length);
        }
        return this.subNamespace(length);
    }

    public YoNamespace removeStart(YoNamespace namespaceToRemove) {
        if (namespaceToRemove == null) {
            return this;
        }
        if (this.equals(namespaceToRemove) || !this.startsWith(namespaceToRemove)) {
            return null;
        }
        return this.removeStart(namespaceToRemove.size());
    }

    public YoNamespace removeEnd(int length) {
        if (length < 0 || length > this.size()) {
            throw new IndexOutOfBoundsException("Invalid length: " + length);
        }
        return this.subNamespace(0, this.size() - length);
    }

    public YoNamespace removeEnd(YoNamespace namespaceToRemove) {
        if (namespaceToRemove == null) {
            return this;
        }
        if (this.equals(namespaceToRemove) || !this.endsWith(namespaceToRemove)) {
            return null;
        }
        return this.removeEnd(namespaceToRemove.size());
    }

    public YoNamespace prepend(YoNamespace other) {
        return YoTools.concatenate(other, this);
    }

    public YoNamespace prepend(String name) {
        return YoTools.concatenate(name, this);
    }

    public YoNamespace append(YoNamespace other) {
        return YoTools.concatenate(this, other);
    }

    public YoNamespace append(String name) {
        return YoTools.concatenate(this, name);
    }

    public boolean endsWith(YoNamespace query) {
        return this.endsWith(query, false);
    }

    public boolean endsWith(YoNamespace query, boolean ignoreCase) {
        if (query.size() > this.size()) {
            return false;
        }
        for (int i = 1; i <= query.size(); ++i) {
            String querySubName = query.subNames.get(query.size() - i);
            String thisSubName = this.subNames.get(this.size() - i);
            if (!(ignoreCase ? !querySubName.equalsIgnoreCase(thisSubName) : !querySubName.equals(thisSubName))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String nameToMatch) {
        return this.endsWith(nameToMatch, false);
    }

    public boolean endsWith(String nameToMatch, boolean ignoreCase) {
        if (nameToMatch.length() > this.name.length()) {
            return false;
        }
        if (ignoreCase ? !StringUtils.endsWithIgnoreCase((CharSequence)this.name, (CharSequence)nameToMatch) : !this.name.endsWith(nameToMatch)) {
            return false;
        }
        if (this.name.length() == nameToMatch.length()) {
            return true;
        }
        return this.name.charAt(this.name.length() - nameToMatch.length() - 1) == '.';
    }

    public boolean startsWith(YoNamespace query) {
        return this.startsWith(query, false);
    }

    public boolean startsWith(YoNamespace query, boolean ignoreCase) {
        if (query.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < query.size(); ++i) {
            if (!(ignoreCase ? !query.subNames.get(i).equalsIgnoreCase(this.subNames.get(i)) : !query.subNames.get(i).equals(this.subNames.get(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String nameToMatch) {
        return this.startsWith(nameToMatch, false);
    }

    public boolean startsWith(String nameToMatch, boolean ignoreCase) {
        if (nameToMatch.length() > this.name.length()) {
            return false;
        }
        if (ignoreCase ? !StringUtils.startsWithIgnoreCase((CharSequence)this.name, (CharSequence)nameToMatch) : !this.name.startsWith(nameToMatch)) {
            return false;
        }
        if (this.name.length() == nameToMatch.length()) {
            return true;
        }
        return this.name.charAt(nameToMatch.length()) == '.';
    }

    public boolean contains(YoNamespace query) {
        return this.contains(query, false);
    }

    public boolean contains(YoNamespace query, boolean ignoreCase) {
        int i;
        if (query.size() > this.size()) {
            return false;
        }
        int startIndex = -1;
        String queryFirstSubName = query.subNames.get(0);
        for (i = 0; i < this.subNames.size() - query.size(); ++i) {
            boolean areEqual = ignoreCase ? this.subNames.get(i).equalsIgnoreCase(queryFirstSubName) : this.subNames.get(i).equals(queryFirstSubName);
            if (!areEqual) continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            return false;
        }
        for (i = 1; i < query.size(); ++i) {
            if (!(ignoreCase ? !query.subNames.get(i).equalsIgnoreCase(this.subNames.get(startIndex + i)) : !query.subNames.get(i).equals(this.subNames.get(startIndex + i)))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String nameToMatch) {
        return this.contains(nameToMatch, false);
    }

    public boolean contains(String nameToMatch, boolean ignoreCase) {
        int startIndex = ignoreCase ? StringUtils.indexOfIgnoreCase((CharSequence)this.name, (CharSequence)nameToMatch) : this.name.indexOf(nameToMatch);
        if (startIndex == -1) {
            return false;
        }
        int endIndex = startIndex + nameToMatch.length();
        if (startIndex > 0 && this.name.charAt(startIndex - 1) != '.') {
            return false;
        }
        return endIndex >= this.name.length() || this.name.charAt(endIndex) == '.';
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoNamespace) {
            return ((YoNamespace)object).name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

