/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import us.ihmc.yoVariables.parameters.AbstractParameterWriter;
import us.ihmc.yoVariables.parameters.xml.Parameter;
import us.ihmc.yoVariables.parameters.xml.Parameters;
import us.ihmc.yoVariables.parameters.xml.Registry;
import us.ihmc.yoVariables.registry.YoNamespace;

public class XmlParameterWriter
extends AbstractParameterWriter {
    private final HashMap<String, Registry> registries = new HashMap();
    private final Parameters parameterRoot = new Parameters();

    public XmlParameterWriter() {
        this.parameterRoot.setRegistries(new ArrayList<Registry>());
    }

    private void addNamespace(YoNamespace namespace) {
        Registry newRegistry = new Registry(namespace.getShortName());
        if (namespace.isRoot()) {
            this.parameterRoot.getRegistries().add(newRegistry);
        } else {
            YoNamespace parent = namespace.removeEnd(1);
            if (!this.registries.containsKey(parent.getName())) {
                this.addNamespace(parent);
            }
            this.registries.get(parent.getName()).getRegistries().add(newRegistry);
        }
        this.registries.put(namespace.getName(), newRegistry);
    }

    @Override
    protected void setValue(YoNamespace namespace, String name, String description, String type, String value, String min, String max) {
        String namespaceAsString = namespace.getName();
        if (!this.registries.containsKey(namespaceAsString)) {
            this.addNamespace(namespace);
        }
        Parameter newParameter = new Parameter(name, type, value, min, max);
        if (description != null && !description.trim().isEmpty()) {
            newParameter.setDescription(description);
        } else {
            newParameter.setDescription(null);
        }
        this.registries.get(namespace.getName()).getParameters().add(newParameter);
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Parameters.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)this.parameterRoot, outputStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

