/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class IntegerParameter
extends YoParameter
implements IntegerProvider {
    private static final int DefaultSuggestedMinimum = -10;
    private static final int DefaultSuggestedMaximum = 10;
    private final YoInteger value;
    private final int initialValue;

    public IntegerParameter(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public IntegerParameter(String name, YoRegistry registry, int lowerBound, int upperBound) {
        this(name, "", registry, lowerBound, upperBound);
    }

    public IntegerParameter(String name, String description, YoRegistry registry) {
        this(name, description, registry, 0);
    }

    public IntegerParameter(String name, String description, YoRegistry registry, int lowerBound, int upperBound) {
        this(name, description, registry, 0, lowerBound, upperBound);
    }

    public IntegerParameter(String name, YoRegistry registry, int initialValue) {
        this(name, "", registry, initialValue);
    }

    public IntegerParameter(String name, YoRegistry registry, int initialValue, int lowerBound, int upperBound) {
        this(name, "", registry, initialValue, lowerBound, upperBound);
    }

    public IntegerParameter(String name, String description, YoRegistry registry, int initialValue) {
        this(name, description, registry, initialValue, -10, 10);
    }

    public IntegerParameter(String name, String description, YoRegistry registry, int initialValue, int lowerBound, int upperBound) {
        this.value = new YoIntegerParameter(name, description, registry);
        this.initialValue = initialValue;
        this.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    public int getValue() {
        this.checkLoaded();
        return this.value.getIntegerValue();
    }

    public void setParameterBounds(int lowerBound, int upperBound) {
        super.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    YoInteger getVariable() {
        return this.value;
    }

    @Override
    void setToDefault() {
        this.value.set(this.initialValue);
    }

    private class YoIntegerParameter
    extends YoInteger {
        public YoIntegerParameter(String name, String description, YoRegistry registry) {
            super(name, description, registry);
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public IntegerParameter getParameter() {
            return IntegerParameter.this;
        }

        @Override
        public YoInteger duplicate(YoRegistry newRegistry) {
            IntegerParameter newParameter = new IntegerParameter(this.getName(), this.getDescription(), newRegistry, IntegerParameter.this.initialValue, (int)this.getLowerBound(), (int)this.getUpperBound());
            newParameter.value.set(IntegerParameter.this.value.getValue());
            newParameter.loadStatus = IntegerParameter.this.getLoadStatus();
            return newParameter.value;
        }
    }
}

