/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.EnumProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class EnumParameter<E extends Enum<E>>
extends YoParameter
implements EnumProvider<E> {
    private final YoEnum<E> value;
    private final int initialOrdinal;

    public EnumParameter(String name, YoRegistry registry, Class<E> enumType, boolean allowNullValue) {
        this(name, "", registry, enumType, allowNullValue);
    }

    public EnumParameter(String name, String description, YoRegistry registry, Class<E> enumType, boolean allowNullValue) {
        this(name, description, registry, (Class<Object>)enumType, allowNullValue, (allowNullValue ? null : ((Enum[])enumType.getEnumConstants())[0]));
    }

    public EnumParameter(String name, YoRegistry registry, Class<E> enumType, boolean allowNullValue, E initialValue) {
        this(name, "", registry, enumType, allowNullValue, initialValue);
    }

    public EnumParameter(String name, String description, YoRegistry registry, Class<E> enumType, boolean allowNullValue, E initialValue) {
        this.value = new YoEnumParameter(name, description, registry, enumType, allowNullValue);
        if (!this.value.isNullAllowed() && initialValue == null) {
            throw new IllegalArgumentException("Cannot initialize to null value, allowNullValue is false");
        }
        this.initialOrdinal = initialValue == null ? -1 : ((Enum)initialValue).ordinal();
    }

    public EnumParameter(String name, String description, YoRegistry registry, boolean allowNullValues, String ... constants) {
        this.value = new YoEnumParameter(name, description, registry, allowNullValues, constants);
        this.initialOrdinal = allowNullValues || constants.length == 0 ? -1 : 0;
    }

    @Override
    public E getValue() {
        this.checkLoaded();
        return this.value.getEnumValue();
    }

    public boolean isBackedByEnum() {
        return this.value.isBackedByEnum();
    }

    public boolean isNullAllowed() {
        return this.value.isNullAllowed();
    }

    public Class<E> getEnumType() {
        return this.value.getEnumType();
    }

    public E[] getEnumValues() {
        return this.value.getEnumValues();
    }

    public String[] getEnumValuesAsString() {
        return this.value.getEnumValuesAsString();
    }

    public int getEnumSize() {
        return this.value.getEnumSize();
    }

    @Override
    YoVariable getVariable() {
        return this.value;
    }

    @Override
    void setToDefault() {
        this.value.set(this.initialOrdinal);
    }

    private class YoEnumParameter
    extends YoEnum<E> {
        public YoEnumParameter(String name, String description, YoRegistry registry, Class<E> enumType, boolean allowNullValues) {
            super(name, description, registry, enumType, allowNullValues);
        }

        public YoEnumParameter(String name, String description, YoRegistry registry, boolean allowNullValues, String ... values) {
            super(name, description, registry, allowNullValues, values);
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public EnumParameter<E> getParameter() {
            return EnumParameter.this;
        }

        @Override
        public YoEnum<E> duplicate(YoRegistry newRegistry) {
            EnumParameter<Object> newParameter;
            if (this.isBackedByEnum()) {
                Enum initialValue = EnumParameter.this.initialOrdinal == -1 ? null : this.getEnumValues()[EnumParameter.this.initialOrdinal];
                newParameter = new EnumParameter<Enum>(this.getName(), this.getDescription(), newRegistry, this.getEnumType(), this.isNullAllowed(), initialValue);
            } else {
                newParameter = new EnumParameter(this.getName(), this.getDescription(), newRegistry, this.isNullAllowed(), this.getEnumValuesAsString());
            }
            newParameter.value.set(EnumParameter.this.value.getOrdinal());
            newParameter.loadStatus = EnumParameter.this.getLoadStatus();
            return newParameter.value;
        }
    }
}

