/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DoubleParameter
extends YoParameter
implements DoubleProvider {
    private static final double defaultSuggestedMinimum = 0.0;
    private static final double defaultSuggestedMaximum = 1.0;
    private final YoDouble value;
    private final double initialValue;

    public DoubleParameter(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public DoubleParameter(String name, YoRegistry registry, double lowerBound, double upperBound) {
        this(name, "", registry, lowerBound, upperBound);
    }

    public DoubleParameter(String name, String description, YoRegistry registry) {
        this(name, description, registry, Double.NaN);
    }

    public DoubleParameter(String name, String description, YoRegistry registry, double lowerBound, double upperBound) {
        this(name, description, registry, Double.NaN, lowerBound, upperBound);
    }

    public DoubleParameter(String name, YoRegistry registry, double initialValue) {
        this(name, "", registry, initialValue);
    }

    public DoubleParameter(String name, YoRegistry registry, double initialValue, double lowerBound, double upperBound) {
        this(name, "", registry, initialValue, lowerBound, upperBound);
    }

    public DoubleParameter(String name, String description, YoRegistry registry, double initialValue) {
        this(name, description, registry, initialValue, 0.0, 1.0);
    }

    public DoubleParameter(String name, String description, YoRegistry registry, double initialValue, double lowerBound, double upperBound) {
        this.value = new YoDoubleParameter(name, description, registry);
        this.initialValue = initialValue;
        this.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    public double getValue() {
        this.checkLoaded();
        return this.value.getDoubleValue();
    }

    @Override
    public void setParameterBounds(double lowerBound, double upperBound) {
        super.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    YoDouble getVariable() {
        return this.value;
    }

    @Override
    void setToDefault() {
        this.value.set(this.initialValue);
    }

    private class YoDoubleParameter
    extends YoDouble {
        public YoDoubleParameter(String name, String description, YoRegistry registry) {
            super(name, description, registry);
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public DoubleParameter getParameter() {
            return DoubleParameter.this;
        }

        @Override
        public YoDouble duplicate(YoRegistry newRegistry) {
            DoubleParameter newParameter = new DoubleParameter(this.getName(), this.getDescription(), newRegistry, DoubleParameter.this.initialValue, this.getLowerBound(), this.getUpperBound());
            newParameter.value.set(DoubleParameter.this.value.getValue());
            newParameter.loadStatus = DoubleParameter.this.getLoadStatus();
            return newParameter.value;
        }
    }
}

