/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.ihmc.yoVariables.parameters.ParameterData;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class AbstractParameterReader {
    public void readParametersInRegistry(YoRegistry registry) {
        this.readParametersInRegistry(registry, new HashSet<String>(), new HashSet<String>());
    }

    public void readParametersInRegistry(YoRegistry registry, Set<String> defaultParametersToPack, Set<String> unmatchedParametersToPack) {
        defaultParametersToPack.clear();
        unmatchedParametersToPack.clear();
        List<YoParameter> parameters = registry.collectSubtreeParameters();
        HashMap<String, ParameterData> localMap = new HashMap<String, ParameterData>(this.getValues());
        for (int i = 0; i < parameters.size(); ++i) {
            YoParameter parameter = parameters.get(i);
            YoNamespace relativeNamespace = AbstractParameterReader.getRelativeNamespace(parameter.getNamespace(), registry);
            String fullName = relativeNamespace + "." + parameter.getName();
            ParameterData data = (ParameterData)localMap.remove(fullName);
            if (data != null) {
                data.setParameterFromThis(parameter);
                continue;
            }
            parameter.loadDefault();
            defaultParametersToPack.add(fullName);
        }
        unmatchedParametersToPack.addAll(localMap.keySet());
    }

    protected abstract Map<String, ParameterData> getValues();

    static YoNamespace getRelativeNamespace(YoNamespace parameterNamespace, YoRegistry registry) {
        YoNamespace registryNamespace = registry.getNamespace();
        if (registryNamespace.isRoot()) {
            return parameterNamespace;
        }
        return parameterNamespace.removeStart(registry.getNamespace().removeEnd(1));
    }
}

