/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame.interfaces;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;

public interface FrameIndexMap {
    public static final long NO_ENTRY_KEY = -1L;

    public void put(ReferenceFrame var1);

    public ReferenceFrame getReferenceFrame(long var1);

    public long getFrameIndex(ReferenceFrame var1);

    default public void putAll(Collection<? extends ReferenceFrame> referenceFrames) {
        referenceFrames.forEach(referenceFrame -> this.put((ReferenceFrame)referenceFrame));
    }

    default public void putAll(List<? extends ReferenceFrame> referenceFrames) {
        for (int i = 0; i < referenceFrames.size(); ++i) {
            this.put(referenceFrames.get(i));
        }
    }

    default public void putAll(ReferenceFrame[] referenceFrames) {
        for (int i = 0; i < referenceFrames.length; ++i) {
            this.put(referenceFrames[i]);
        }
    }

    public static class FrameIndexFinder
    implements FrameIndexMap {
        private final ReferenceFrame rootFrame;

        public FrameIndexFinder(ReferenceFrame rootFrame) {
            this.rootFrame = rootFrame.getRootFrame();
        }

        @Override
        public void put(ReferenceFrame referenceFrame) {
            if (referenceFrame.getRootFrame() != this.rootFrame) {
                throw new RuntimeException("Root frame of " + referenceFrame.getName() + " is " + referenceFrame.getRootFrame().getName() + ". This mapper only supports frame in the tree with root frame " + this.rootFrame.getName() + ".");
            }
        }

        @Override
        public ReferenceFrame getReferenceFrame(long frameIndex) {
            if (frameIndex == -1L) {
                return null;
            }
            Collection allFramesInTree = ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)this.rootFrame);
            Optional<ReferenceFrame> match = allFramesInTree.stream().filter(referenceFrame -> referenceFrame.getFrameIndex() == frameIndex).findFirst();
            if (match.isPresent()) {
                return match.get();
            }
            throw new RuntimeException("Can not get the frame for index " + frameIndex + " because the frame index is unknown to the mapper.");
        }

        @Override
        public long getFrameIndex(ReferenceFrame referenceFrame) {
            if (referenceFrame == null) {
                return -1L;
            }
            return referenceFrame.getFrameIndex();
        }
    }

    public static class FrameIndexHashMap
    implements FrameIndexMap {
        private final TLongObjectMap<ReferenceFrame> frameIndexMap = new TLongObjectHashMap(10, 0.5f, -1L);

        @Override
        public void put(ReferenceFrame referenceFrame) {
            if (referenceFrame != null) {
                this.frameIndexMap.putIfAbsent(referenceFrame.getFrameIndex(), (Object)referenceFrame);
            }
        }

        @Override
        public ReferenceFrame getReferenceFrame(long frameIndex) {
            if (frameIndex == -1L) {
                return null;
            }
            ReferenceFrame referenceFrame = (ReferenceFrame)this.frameIndexMap.get(frameIndex);
            if (referenceFrame != null) {
                return referenceFrame;
            }
            throw new RuntimeException("Can not get the frame for index " + frameIndex + " because the frame index is unknown to the mapper.");
        }

        @Override
        public long getFrameIndex(ReferenceFrame referenceFrame) {
            if (referenceFrame == null) {
                return -1L;
            }
            if (this.frameIndexMap.containsValue((Object)referenceFrame)) {
                return referenceFrame.getFrameIndex();
            }
            throw new RuntimeException("Can not get the frame index for reference frame " + referenceFrame.getName() + " because frame is unknown to the mapper.");
        }
    }
}

