/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.YoTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public abstract class YoMutableFrameTuple3D
extends YoTuple3D
implements FrameTuple3DBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry);
        this.setToZero(referenceFrame);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double x, double y, double z) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, x, y, z);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double[] tupleArray) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tupleArray);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly, 0.0);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameTuple2DReadOnly, 0.0);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry, FrameTuple3DReadOnly frameTuple3DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameTuple3DReadOnly);
    }

    public YoMutableFrameTuple3D(String namePrefix, String nameSuffix, YoRegistry registry) {
        super(namePrefix, nameSuffix, registry);
        this.frameId = new YoLong(YoGeometryNameTools.assembleName(namePrefix, "frame", nameSuffix), registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        this.setReferenceFrame(ReferenceFrame.getWorldFrame());
    }

    public YoMutableFrameTuple3D(YoDouble x, YoDouble y, YoDouble z, YoLong frameIndex, FrameIndexMap frameIndexMap) {
        super(x, y, z);
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        YoMutableFrameObject.super.setReferenceFrame(referenceFrame);
    }

    @Override
    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    @Override
    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    @Override
    public String toString() {
        return EuclidFrameIOTools.getFrameTuple3DString((FrameTuple3DReadOnly)this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FrameTuple3DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameTuple3DReadOnly)object));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
    }
}

