/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoMutableFramePose3D
implements FramePose3DBasics,
YoMutableFrameObject {
    private final YoMutableFramePoint3D position;
    private final YoMutableFrameQuaternion orientation;
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;

    public YoMutableFramePose3D(YoMutableFramePoint3D position, YoMutableFrameQuaternion orientation) {
        this.position = position;
        this.orientation = orientation;
        this.frameId = position.getYoFrameIndex();
        this.frameIndexMap = position.getFrameIndexMap();
        this.checkFrameConsistency();
    }

    public YoMutableFramePose3D(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.frameId = new YoLong(YoGeometryNameTools.assembleName(namePrefix, "frame", nameSuffix), registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        YoDouble x = new YoDouble(YoGeometryNameTools.createXName(namePrefix, nameSuffix), registry);
        YoDouble y = new YoDouble(YoGeometryNameTools.createYName(namePrefix, nameSuffix), registry);
        YoDouble z = new YoDouble(YoGeometryNameTools.createZName(namePrefix, nameSuffix), registry);
        this.position = new YoMutableFramePoint3D(x, y, z, this.getYoFrameIndex(), this.getFrameIndexMap());
        YoDouble qx = new YoDouble(YoGeometryNameTools.createQxName(namePrefix, nameSuffix), registry);
        YoDouble qy = new YoDouble(YoGeometryNameTools.createQyName(namePrefix, nameSuffix), registry);
        YoDouble qz = new YoDouble(YoGeometryNameTools.createQzName(namePrefix, nameSuffix), registry);
        YoDouble qs = new YoDouble(YoGeometryNameTools.createQsName(namePrefix, nameSuffix), registry);
        this.orientation = new YoMutableFrameQuaternion(qx, qy, qz, qs, this.getYoFrameIndex(), this.getFrameIndexMap());
        this.setReferenceFrame(ReferenceFrame.getWorldFrame());
    }

    public FixedFramePoint3DBasics getPosition() {
        this.checkFrameConsistency();
        return this.position;
    }

    public FixedFrameQuaternionBasics getOrientation() {
        this.checkFrameConsistency();
        return this.orientation;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        this.checkFrameConsistency();
        return YoMutableFrameObject.super.getReferenceFrame();
    }

    @Override
    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    @Override
    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        YoMutableFrameObject.super.setReferenceFrame(referenceFrame);
        this.orientation.setReferenceFrame(referenceFrame);
    }

    private void checkFrameConsistency() {
        if (this.position.getReferenceFrame() == null) {
            if (this.orientation.getReferenceFrame() != null) {
                this.orientation.getReferenceFrame().checkReferenceFrameMatch(this.position.getReferenceFrame());
            }
        } else {
            this.position.checkReferenceFrameMatch(this.orientation);
        }
    }

    public String toString() {
        return EuclidFrameIOTools.getFramePose3DString((FramePose3DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof FramePose3DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FramePose3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getOrientation());
    }
}

