/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFramePoseUsingYawPitchRoll
implements FramePose3DReadOnly,
Clearable,
Transformable {
    private final YoFramePoint3D position;
    private final YoFrameYawPitchRoll yawPitchRoll;
    private final FrameQuaternion frameQuaternion = new FrameQuaternion();

    public YoFramePoseUsingYawPitchRoll(YoFramePoint3D position, YoFrameYawPitchRoll orientation) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.position = position;
        this.yawPitchRoll = orientation;
    }

    public YoFramePoseUsingYawPitchRoll(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFramePoseUsingYawPitchRoll(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this.position = new YoFramePoint3D(namePrefix, nameSuffix, referenceFrame, registry);
        this.yawPitchRoll = new YoFrameYawPitchRoll(namePrefix, nameSuffix, referenceFrame, registry);
    }

    public YoFramePoint3D getPosition() {
        return this.position;
    }

    public FrameQuaternionReadOnly getOrientation() {
        this.frameQuaternion.setIncludingFrame((FrameOrientation3DReadOnly)this.yawPitchRoll);
        return this.frameQuaternion;
    }

    public YoFrameYawPitchRoll getYawPitchRoll() {
        return this.yawPitchRoll;
    }

    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    public void setPosition(Tuple3DReadOnly position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setPosition(Tuple2DReadOnly position2D) {
        this.position.set(position2D);
    }

    public void setPosition(Tuple2DReadOnly position2D, double z) {
        this.position.set(position2D, z);
    }

    public void set(double x, double y, double z, double yaw, double pitch, double roll) {
        this.setPosition(x, y, z);
        this.setOrientationYawPitchRoll(yaw, pitch, roll);
    }

    public void set(Pose2DReadOnly pose2DReadOnly) {
        this.setPosition((Tuple2DReadOnly)pose2DReadOnly.getPosition(), 0.0);
        this.setOrientation(pose2DReadOnly.getOrientation());
    }

    public void set(Pose3DReadOnly other) {
        this.setPosition((Tuple3DReadOnly)other.getPosition());
        this.setOrientation((Orientation3DReadOnly)other.getOrientation());
    }

    public void setOrientation(Orientation2DReadOnly orientation) {
        this.yawPitchRoll.set(orientation.getYaw(), 0.0, 0.0);
    }

    public void setOrientation(Orientation3DReadOnly orientation) {
        this.yawPitchRoll.set(orientation);
    }

    public void setOrientationYawPitchRoll(double yaw, double pitch, double roll) {
        this.yawPitchRoll.setYawPitchRoll(yaw, pitch, roll);
    }

    public void set(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.setPosition(rigidBodyTransform.getTranslation());
        this.setOrientation(rigidBodyTransform.getRotation());
    }

    public void set(Tuple3DReadOnly position, Orientation3DReadOnly orientation) {
        this.setOrientation(orientation);
        this.setPosition(position);
    }

    public boolean containsNaN() {
        return this.yawPitchRoll.containsNaN() || this.position.containsNaN();
    }

    public void setToNaN() {
        this.yawPitchRoll.setToNaN();
        this.position.setToNaN();
    }

    public void setToZero() {
        this.yawPitchRoll.setToZero();
        this.position.setToZero();
    }

    public void interpolate(Pose3DReadOnly other, double alpha) {
        this.position.interpolate((Tuple3DReadOnly)other.getPosition(), alpha);
        this.frameQuaternion.setReferenceFrame(this.getReferenceFrame());
        this.frameQuaternion.interpolate(other.getOrientation(), alpha);
        this.yawPitchRoll.set((FrameOrientation3DReadOnly)this.frameQuaternion);
    }

    public void interpolate(Pose3DReadOnly pose1, Pose3DReadOnly pose2, double alpha) {
        this.position.interpolate((Tuple3DReadOnly)pose1.getPosition(), (Tuple3DReadOnly)pose2.getPosition(), alpha);
        this.frameQuaternion.setReferenceFrame(this.getReferenceFrame());
        this.frameQuaternion.interpolate(pose1.getOrientation(), pose2.getOrientation(), alpha);
        this.yawPitchRoll.set((FrameOrientation3DReadOnly)this.frameQuaternion);
    }

    public void prependTranslation(double x, double y, double z) {
        this.position.add(x, y, z);
    }

    public void prependTranslation(Tuple3DReadOnly translation) {
        this.prependTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public void prependRotation(Orientation3DReadOnly rotation) {
        rotation.transform((Tuple3DBasics)this.position);
        rotation.transform((Orientation3DBasics)this.yawPitchRoll);
    }

    public void prependYawRotation(double yaw) {
        RotationMatrixTools.applyYawRotation((double)yaw, (Tuple3DReadOnly)this.position, (Tuple3DBasics)this.position);
        this.yawPitchRoll.prependYawRotation(yaw);
    }

    public void prependPitchRotation(double pitch) {
        RotationMatrixTools.applyPitchRotation((double)pitch, (Tuple3DReadOnly)this.position, (Tuple3DBasics)this.position);
        this.yawPitchRoll.prependPitchRotation(pitch);
    }

    public void prependRollRotation(double roll) {
        RotationMatrixTools.applyRollRotation((double)roll, (Tuple3DReadOnly)this.position, (Tuple3DBasics)this.position);
        this.yawPitchRoll.prependRollRotation(roll);
    }

    public void prependTransform(RigidBodyTransformReadOnly transform) {
        this.applyTransform((Transform)transform);
    }

    public void appendTranslation(double x, double y, double z) {
        double thisX = this.getX();
        double thisY = this.getY();
        double thisZ = this.getZ();
        this.setPosition(x, y, z);
        this.yawPitchRoll.transform(this.position);
        this.position.add(thisX, thisY, thisZ);
    }

    public void appendTranslation(Tuple3DReadOnly translation) {
        this.appendTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public void appendRotation(Orientation3DReadOnly orientation) {
        this.yawPitchRoll.append(orientation);
    }

    public void appendYawRotation(double yaw) {
        this.yawPitchRoll.appendYawRotation(yaw);
    }

    public void appendPitchRotation(double pitch) {
        this.yawPitchRoll.appendPitchRotation(pitch);
    }

    public void appendRollRotation(double roll) {
        this.yawPitchRoll.appendRollRotation(roll);
    }

    public void appendTransform(RigidBodyTransformReadOnly transform) {
        YawPitchRollTools.addTransform((YawPitchRollReadOnly)this.yawPitchRoll, (Tuple3DReadOnly)transform.getTranslation(), (Tuple3DBasics)this.position);
        this.yawPitchRoll.append(transform.getRotation());
    }

    public void applyTransform(Transform transform) {
        transform.transform((Point3DBasics)this.position);
        transform.transform((Orientation3DBasics)this.yawPitchRoll);
    }

    public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((Point3DBasics)this.position);
        transform.inverseTransform((Orientation3DBasics)this.yawPitchRoll);
    }

    public void setFromReferenceFrame(ReferenceFrame referenceFrame) {
        this.setToZero();
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    public void setPosition(FrameTuple2DReadOnly position) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.setPosition((Tuple2DReadOnly)position);
    }

    public void setPosition(FrameTuple2DReadOnly position, double z) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.setPosition((Tuple2DReadOnly)position, z);
    }

    public void setPosition(FrameTuple3DReadOnly position) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.setPosition((Tuple3DReadOnly)position);
    }

    public void setOrientation(FrameOrientation2DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setOrientation((Orientation2DReadOnly)orientation);
    }

    public void setOrientation(FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.setOrientation((Orientation3DReadOnly)orientation);
    }

    public void set(ReferenceFrame referenceFrame, Pose2DReadOnly pose2DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose2DReadOnly);
    }

    public void set(ReferenceFrame referenceFrame, Pose3DReadOnly pose3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(pose3DReadOnly);
    }

    public void set(FramePose2DReadOnly framePose2DReadOnly) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)framePose2DReadOnly);
        this.set((Pose2DReadOnly)framePose2DReadOnly);
    }

    public void set(FramePose3DReadOnly other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.set((Pose3DReadOnly)other);
    }

    public void setMatchingFrame(FramePose3DReadOnly other) {
        this.set((Pose3DReadOnly)other);
        other.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    public void set(FrameTuple3DReadOnly position, Orientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.set((Tuple3DReadOnly)position, orientation);
    }

    public void set(Tuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set(position, (Orientation3DReadOnly)orientation);
    }

    public void set(FrameTuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        this.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        this.set((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
    }

    public void prependTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.prependTranslation((Tuple3DReadOnly)translation);
    }

    public void prependRotation(FrameOrientation3DReadOnly rotation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rotation);
        this.prependRotation((Orientation3DReadOnly)rotation);
    }

    public void appendTranslation(FrameTuple3DReadOnly translation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)translation);
        this.appendTranslation((Tuple3DReadOnly)translation);
    }

    public void appendRotation(FrameOrientation3DReadOnly rotation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rotation);
        this.appendRotation((Orientation3DReadOnly)rotation);
    }

    public void interpolate(FramePose3DReadOnly other, double alpha) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.interpolate((Pose3DReadOnly)other, alpha);
    }

    public void interpolate(FramePose3DReadOnly pose1, Pose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pose1);
        this.interpolate((Pose3DReadOnly)pose1, pose2, alpha);
    }

    public void interpolate(Pose3DReadOnly pose1, FramePose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pose2);
        this.interpolate(pose1, (Pose3DReadOnly)pose2, alpha);
    }

    public void interpolate(FramePose3DReadOnly pose1, FramePose3DReadOnly pose2, double alpha) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pose1);
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pose2);
        this.interpolate((Pose3DReadOnly)pose1, (Pose3DReadOnly)pose2, alpha);
    }

    public void set(YoFramePoseUsingYawPitchRoll other) {
        this.set((FrameTuple3DReadOnly)other.position, (FrameOrientation3DReadOnly)other.yawPitchRoll);
    }

    public void setMatchingFrame(YoFramePoseUsingYawPitchRoll other) {
        this.setMatchingFrame((FrameTuple3DReadOnly)other.position, (FrameOrientation3DReadOnly)other.yawPitchRoll);
    }

    public void setMatchingFrame(FrameTuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.position.setMatchingFrame(position);
        this.yawPitchRoll.setMatchingFrame(orientation);
    }

    public void add(YoFramePoseUsingYawPitchRoll other) {
        this.position.add((FrameTuple3DReadOnly)other.position);
        this.yawPitchRoll.add(other.yawPitchRoll);
    }

    public void setYaw(double yaw) {
        this.yawPitchRoll.setYaw(yaw);
    }

    public void setPitch(double pitch) {
        this.yawPitchRoll.setPitch(pitch);
    }

    public void setRoll(double roll) {
        this.yawPitchRoll.setRoll(roll);
    }

    public void setX(double x) {
        this.position.setX(x);
    }

    public void setY(double y) {
        this.position.setY(y);
    }

    public void setZ(double z) {
        this.position.setZ(z);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.position.getReferenceFrame();
    }

    public void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.position.attachVariableChangedListener(variableChangedListener);
        this.yawPitchRoll.attachVariableChangedListener(variableChangedListener);
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public double getZ() {
        return this.position.getZ();
    }

    public double getRoll() {
        return this.yawPitchRoll.getRoll();
    }

    public double getPitch() {
        return this.yawPitchRoll.getPitch();
    }

    public double getYaw() {
        return this.yawPitchRoll.getYaw();
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    public YoDouble getYoYaw() {
        return this.yawPitchRoll.getYoYaw();
    }

    public YoDouble getYoPitch() {
        return this.yawPitchRoll.getYoPitch();
    }

    public YoDouble getYoRoll() {
        return this.yawPitchRoll.getYoRoll();
    }

    public YoFramePoseUsingYawPitchRoll duplicate(YoRegistry newRegistry) {
        return new YoFramePoseUsingYawPitchRoll(this.position.duplicate(newRegistry), this.yawPitchRoll.duplicate(newRegistry));
    }

    public boolean equals(YoFramePoseUsingYawPitchRoll other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.position.equals((EuclidFrameGeometry)other.position) && this.yawPitchRoll.equals((EuclidFrameGeometry)other.yawPitchRoll);
    }

    public boolean equals(Object object) {
        if (object instanceof YoFramePoseUsingYawPitchRoll) {
            return this.equals((YoFramePoseUsingYawPitchRoll)object);
        }
        if (object instanceof FramePose3DReadOnly) {
            return super.equals((EuclidFrameGeometry)((FramePose3DReadOnly)object));
        }
        return false;
    }

    public String toString() {
        return EuclidFrameIOTools.getFramePose3DString((FramePose3DReadOnly)this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getOrientation());
    }
}

