/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameUnitVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameLine2D
implements FixedFrameLine2DBasics {
    private final YoFramePoint2D point;
    private final YoFrameUnitVector2D direction;

    public YoFrameLine2D(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFrameLine2D(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this.point = new YoFramePoint2D(namePrefix + "Point", nameSuffix, referenceFrame, registry);
        this.direction = new YoFrameUnitVector2D(namePrefix + "Direction", nameSuffix, referenceFrame, registry);
    }

    public YoFrameLine2D(YoFramePoint2D point, YoFrameVector2D direction) {
        this(point.getYoX(), point.getYoY(), direction.getYoX(), direction.getYoY(), point.getReferenceFrame());
        point.checkReferenceFrameMatch((ReferenceFrameHolder)direction);
    }

    public YoFrameLine2D(YoFramePoint2D point, YoFrameUnitVector2D direction) {
        this(point.getYoX(), point.getYoY(), direction.getYoX(), direction.getYoY(), point.getReferenceFrame());
        point.checkReferenceFrameMatch((ReferenceFrameHolder)direction);
    }

    public YoFrameLine2D(YoDouble pointX, YoDouble pointY, YoDouble directionX, YoDouble directionY, ReferenceFrame referenceFrame) {
        this.point = new YoFramePoint2D(pointX, pointY, referenceFrame);
        this.direction = new YoFrameUnitVector2D(directionX, directionY, referenceFrame);
    }

    public YoFramePoint2D getPoint() {
        return this.point;
    }

    public YoFrameUnitVector2D getDirection() {
        return this.direction;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.point.getReferenceFrame();
    }

    public YoDouble getYoPointX() {
        return this.point.getYoX();
    }

    public YoDouble getYoPointY() {
        return this.point.getYoY();
    }

    public YoDouble getYoDirectionX() {
        return this.direction.getYoX();
    }

    public YoDouble getYoDirectionY() {
        return this.direction.getYoY();
    }

    public YoFrameLine2D duplicate(YoRegistry newRegistry) {
        return new YoFrameLine2D(this.point.duplicate(newRegistry), this.direction.duplicate(newRegistry));
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameLine2DString((FrameLine2DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLine2DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameLine2DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPoint(), (Object)this.getDirection());
    }
}

