/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import java.util.Arrays;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.yoVariables.buffer.YoBufferBounds;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBufferVariableEntry
implements YoBufferVariableEntryReader {
    private final YoVariable variable;
    private double[] bufferData;
    private final YoBufferBounds currentBounds = new YoBufferBounds();
    private boolean boundsChanged = true;
    private boolean boundsDirty = true;
    private boolean useCustomBounds = false;
    private final YoBufferBounds customBounds = new YoBufferBounds();
    private boolean inverted = false;

    public YoBufferVariableEntry(YoVariable variable, int bufferSize) {
        this.variable = variable;
        this.clearBuffer(bufferSize);
    }

    public YoBufferVariableEntry(YoBufferVariableEntry other) {
        this.variable = other.getVariable();
        this.bufferData = Arrays.copyOf(other.bufferData, other.getBufferSize());
        this.currentBounds.set(other.currentBounds);
        this.boundsChanged = other.boundsChanged;
        this.boundsDirty = other.boundsDirty;
        this.useCustomBounds = other.useCustomBounds;
        this.customBounds.set(other.customBounds);
        this.inverted = other.inverted;
    }

    protected void clearBuffer(int bufferSize) {
        this.bufferData = new double[bufferSize];
        this.currentBounds.clear();
        this.boundsDirty = true;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public boolean getInverted() {
        return this.inverted;
    }

    @Override
    public int getBufferSize() {
        return this.bufferData.length;
    }

    public synchronized void writeIntoBufferAt(int index) {
        this.writeBufferAt(this.variable.getValueAsDouble(), index);
    }

    public void writeBufferAt(double value, int index) {
        if (this.bufferData[index] == value) {
            return;
        }
        this.bufferData[index] = value;
        if (this.currentBounds.update(value)) {
            this.boundsChanged = true;
        }
    }

    protected void readFromBufferAt(int index) {
        this.variable.setValueFromDouble(this.bufferData[index]);
    }

    @Override
    public double readBufferAt(int index) {
        return this.bufferData[index];
    }

    @Override
    public double[] getBuffer() {
        return this.getBufferWindow(0, this.bufferData.length);
    }

    @Override
    public double[] getBufferWindow(int startIndex, int length) {
        double[] sample = new double[length];
        int n = startIndex;
        for (int i = 0; i < length; ++i) {
            sample[i] = this.bufferData[n];
            if (++n < this.bufferData.length) continue;
            n = 0;
        }
        return sample;
    }

    @Override
    public void useCustomBounds(boolean autoScale) {
        this.useCustomBounds = !autoScale;
    }

    @Override
    public boolean isUsingCustomBounds() {
        return !this.useCustomBounds;
    }

    @Override
    public YoVariable getVariable() {
        return this.variable;
    }

    protected void fillBuffer() {
        double value = this.variable.getValueAsDouble();
        for (int i = 0; i < this.bufferData.length; ++i) {
            this.bufferData[i] = value;
        }
        this.currentBounds.clear();
    }

    protected void enlargeBufferSize(int newSize) {
        int i;
        double[] oldData = this.bufferData;
        int oldNPoints = oldData.length;
        this.bufferData = new double[newSize];
        for (i = 0; i < oldNPoints; ++i) {
            this.bufferData[i] = oldData[i];
        }
        for (i = oldNPoints; i < this.bufferData.length; ++i) {
            this.bufferData[i] = oldData[oldNPoints - 1];
        }
        this.boundsDirty = true;
    }

    protected int cropBuffer(int start, int end) {
        if (start < 0 || end > this.bufferData.length) {
            return -1;
        }
        double[] oldData = this.bufferData;
        int oldNPoints = oldData.length;
        int nPoints = YoBufferVariableEntry.computeBufferSizeAfterCrop(start, end, oldNPoints);
        this.bufferData = new double[nPoints];
        for (int i = 0; i < this.bufferData.length; ++i) {
            this.bufferData[i] = oldData[(i + start) % oldNPoints];
        }
        this.boundsDirty = true;
        return this.bufferData.length;
    }

    protected int cutBuffer(int start, int end) {
        int i;
        if (start > end) {
            return -1;
        }
        if (start < 0 || end > this.bufferData.length) {
            return -1;
        }
        double[] oldData = this.bufferData;
        int oldNPoints = oldData.length;
        int nPoints = YoBufferVariableEntry.computeBufferSizeAfterCut(start, end, oldNPoints);
        if (nPoints == 0) {
            nPoints = oldNPoints;
        }
        this.bufferData = new double[nPoints];
        int difference = end - start + 1;
        for (i = 0; i < start; ++i) {
            this.bufferData[i] = oldData[i];
        }
        for (i = end + 1; i < oldData.length; ++i) {
            this.bufferData[i - difference] = oldData[i];
        }
        this.boundsDirty = true;
        return this.bufferData.length;
    }

    protected int thinData(int keepEveryNthPoint) {
        double[] oldData = this.bufferData;
        int oldNPoints = oldData.length;
        int newNumberOfPoints = oldNPoints / keepEveryNthPoint;
        this.bufferData = new double[newNumberOfPoints];
        int oldDataIndex = 0;
        for (int index = 0; index < newNumberOfPoints; ++index) {
            this.bufferData[index] = oldData[oldDataIndex];
            oldDataIndex += keepEveryNthPoint;
        }
        return newNumberOfPoints;
    }

    protected static int computeBufferSizeAfterCrop(int start, int end, int previousBufferSize) {
        int newBufferSize = (end - start + 1 + previousBufferSize) % previousBufferSize;
        if (newBufferSize == 0) {
            return previousBufferSize;
        }
        return newBufferSize;
    }

    protected static int computeBufferSizeAfterCut(int start, int end, int previousBufferSize) {
        return previousBufferSize - (end - start + 1);
    }

    protected void shiftBuffer(int shiftIndex) {
        if (shiftIndex <= 0 || shiftIndex >= this.bufferData.length) {
            return;
        }
        double[] oldData = this.bufferData;
        int nPoints = this.bufferData.length;
        this.bufferData = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            this.bufferData[i] = oldData[(i + shiftIndex) % nPoints];
        }
        this.boundsDirty = true;
    }

    @Override
    public synchronized void resetBoundsChangedFlag() {
        this.boundsChanged = false;
    }

    @Override
    public synchronized boolean haveBoundsChanged() {
        return this.boundsChanged;
    }

    private synchronized boolean updateBounds() {
        this.boundsChanged = false;
        if (this.bufferData == null) {
            return false;
        }
        this.currentBounds.setInterval(0, this.getBufferSize() - 1);
        this.boundsChanged = this.currentBounds.compute(this.bufferData);
        return this.boundsChanged;
    }

    @Override
    public YoBufferBounds getBounds() {
        if (this.boundsDirty) {
            this.updateBounds();
        }
        return this.currentBounds;
    }

    @Override
    public YoBufferBounds getCustomBounds() {
        this.customBounds.setInterval(0, this.getBufferSize() - 1);
        this.customBounds.setBounds(this.variable.getLowerBound(), this.variable.getUpperBound());
        return this.customBounds;
    }

    public double computeAverage() {
        return this.computeAverage(0, this.getBufferSize());
    }

    public double computeAverage(int start, int length) {
        if (start < 0 || start >= this.getBufferSize()) {
            throw new IndexOutOfBoundsException("start should be in [0, " + this.getBufferSize() + "[, but was: " + length);
        }
        if (length <= 0 || length > this.getBufferSize()) {
            throw new IndexOutOfBoundsException("length should be in ]0, " + this.getBufferSize() + "], but was: " + length);
        }
        double total = 0.0;
        int index = 0;
        for (int count = 0; count < length; ++count) {
            total += this.bufferData[index];
            if (++index < this.getBufferSize()) continue;
            index = 0;
        }
        return total / (double)length;
    }

    @Override
    public YoBufferBounds getWindowBounds(int startIndex, int endIndex) {
        if (this.bufferData != null && (this.boundsDirty || startIndex != this.currentBounds.getStartIndex() || endIndex != this.currentBounds.getEndIndex())) {
            this.currentBounds.setInterval(startIndex, endIndex);
            this.boundsChanged = this.currentBounds.compute(this.bufferData);
            this.boundsDirty = false;
        }
        return this.currentBounds;
    }

    public boolean epsilonEquals(YoBufferVariableEntry other, double epsilon) {
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        if (!this.getVariableFullNameString().equals(other.getVariableFullNameString())) {
            return false;
        }
        for (int i = 0; i < this.getBufferSize(); ++i) {
            double thisDataPoint = this.bufferData[i];
            double otherDataPoint = other.bufferData[i];
            if (Double.compare(thisDataPoint, otherDataPoint) == 0 || EuclidCoreTools.epsilonEquals((double)thisDataPoint, (double)otherDataPoint, (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "variable: " + this.variable.getName() + ", buffer size: " + this.getBufferSize();
    }
}

