/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

public class YoBufferBounds {
    private int startIndex;
    private int endIndex;
    private double lowerBound;
    private double upperBound;

    public YoBufferBounds() {
        this.clear();
    }

    public void clear() {
        this.startIndex = -1;
        this.endIndex = -1;
        this.lowerBound = Double.POSITIVE_INFINITY;
        this.upperBound = Double.NEGATIVE_INFINITY;
    }

    public void setInterval(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public void setBounds(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void set(YoBufferBounds other) {
        this.startIndex = other.startIndex;
        this.endIndex = other.endIndex;
        this.lowerBound = other.lowerBound;
        this.upperBound = other.upperBound;
    }

    public boolean compute(double[] buffer) {
        double newLowerBound = Double.POSITIVE_INFINITY;
        double newUpperBound = Double.NEGATIVE_INFINITY;
        if (this.startIndex < this.endIndex) {
            for (i = this.startIndex; i < this.endIndex; ++i) {
                double value = buffer[i];
                if (value < newLowerBound) {
                    newLowerBound = value;
                }
                if (!(value > newUpperBound)) continue;
                newUpperBound = value;
            }
        } else {
            double value;
            for (i = this.startIndex; i < buffer.length; ++i) {
                value = buffer[i];
                if (value < newLowerBound) {
                    newLowerBound = value;
                }
                if (!(value > newUpperBound)) continue;
                newUpperBound = value;
            }
            for (i = 0; i < this.endIndex; ++i) {
                value = buffer[i];
                if (value < newLowerBound) {
                    newLowerBound = value;
                }
                if (!(value > newUpperBound)) continue;
                newUpperBound = value;
            }
        }
        boolean changed = false;
        if (newLowerBound != this.lowerBound || newUpperBound != this.upperBound) {
            this.lowerBound = newLowerBound;
            this.upperBound = newUpperBound;
            changed = true;
        }
        return changed;
    }

    public boolean update(double value) {
        boolean changed = false;
        if (value < this.lowerBound) {
            this.lowerBound = value;
            changed = true;
        }
        if (value > this.upperBound) {
            this.upperBound = value;
            changed = true;
        }
        return changed;
    }

    public boolean isInsideBounds(double value) {
        return value >= this.lowerBound && value <= this.upperBound;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }
}

