/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.parameters.ParameterLoadStatus;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoParameter {
    protected ParameterLoadStatus loadStatus = ParameterLoadStatus.UNLOADED;
    private YoParameterChangedListenerHolder changedListenerHolder;

    public String getName() {
        return this.getVariable().getName();
    }

    public String getDescription() {
        return this.getVariable().getDescription();
    }

    public YoNamespace getFullName() {
        return this.getVariable().getFullName();
    }

    public String getFullNameString() {
        return this.getVariable().getFullNameString();
    }

    public YoNamespace getNamespace() {
        return this.getVariable().getNamespace();
    }

    void setParameterBounds(double lowerBound, double upperBound) {
        this.getVariable().setVariableBounds(lowerBound, upperBound);
    }

    public double getLowerBound() {
        return this.getVariable().getLowerBound();
    }

    public double getUpperBound() {
        return this.getVariable().getUpperBound();
    }

    public void addListener(YoParameterChangedListener listener) {
        if (this.changedListenerHolder == null) {
            this.changedListenerHolder = new YoParameterChangedListenerHolder();
            this.getVariable().addListener(this.changedListenerHolder);
        }
        this.changedListenerHolder.addListener(listener);
    }

    public void removeListeners() {
        if (this.changedListenerHolder != null) {
            this.changedListenerHolder.removeListeners();
        }
    }

    public List<YoParameterChangedListener> getListeners() {
        if (this.changedListenerHolder == null) {
            return null;
        }
        return this.changedListenerHolder.getListeners();
    }

    public boolean removeListener(YoParameterChangedListener listener) {
        if (this.changedListenerHolder == null) {
            return false;
        }
        return this.changedListenerHolder.removeListener(listener);
    }

    public final String getValueAsString() {
        this.checkLoaded();
        return this.getVariable().getValueAsString();
    }

    abstract YoVariable getVariable();

    final void setToString(String valueString) {
        this.getVariable().parseValue(valueString);
    }

    abstract void setToDefault();

    void load(String valueString) {
        this.loadStatus = ParameterLoadStatus.LOADED;
        this.setToString(valueString);
    }

    void loadDefault() {
        this.loadStatus = ParameterLoadStatus.DEFAULT;
        this.setToDefault();
    }

    public ParameterLoadStatus getLoadStatus() {
        return this.loadStatus;
    }

    public void checkLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalOperationException("The parameter " + this.getFullName() + " has not been loaded. This is required to enable its use.");
        }
    }

    public boolean isLoaded() {
        return this.loadStatus != ParameterLoadStatus.UNLOADED;
    }

    public String toString() {
        return this.getVariable().toString();
    }

    private static class YoParameterChangedListenerHolder
    implements YoVariableChangedListener {
        private final List<YoParameterChangedListener> changedListeners = new ArrayList<YoParameterChangedListener>();

        private YoParameterChangedListenerHolder() {
        }

        @Override
        public void changed(YoVariable v) {
            for (int i = 0; i < this.changedListeners.size(); ++i) {
                this.changedListeners.get(i).changed(v.getParameter());
            }
        }

        public void addListener(YoParameterChangedListener listener) {
            this.changedListeners.add(listener);
        }

        public void removeListeners() {
            this.changedListeners.clear();
        }

        public boolean removeListener(YoParameterChangedListener listener) {
            return this.changedListeners.remove(listener);
        }

        public List<YoParameterChangedListener> getListeners() {
            return this.changedListeners;
        }
    }
}

