/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.LongProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;

public class LongParameter
extends YoParameter
implements LongProvider {
    private static final long DefaultSuggestedMinimum = -100L;
    private static final long DefaultSuggestedMaximum = 100L;
    private final YoLong value;
    private final long initialValue;

    public LongParameter(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public LongParameter(String name, YoRegistry registry, long lowerBound, long upperBound) {
        this(name, "", registry, lowerBound, upperBound);
    }

    public LongParameter(String name, String description, YoRegistry registry) {
        this(name, "", registry, 0L);
    }

    public LongParameter(String name, String description, YoRegistry registry, long lowerBound, long upperBound) {
        this(name, "", registry, 0L, lowerBound, upperBound);
    }

    public LongParameter(String name, YoRegistry registry, long initialValue) {
        this(name, "", registry, initialValue);
    }

    public LongParameter(String name, YoRegistry registry, long initialValue, long lowerBound, long upperBound) {
        this(name, "", registry, initialValue, lowerBound, upperBound);
    }

    public LongParameter(String name, String description, YoRegistry registry, long initialValue) {
        this(name, description, registry, initialValue, -100L, 100L);
    }

    public LongParameter(String name, String description, YoRegistry registry, long initialValue, long lowerBound, long upperBound) {
        this.value = new YoLongParameter(name, description, registry);
        this.initialValue = initialValue;
        this.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    public long getValue() {
        this.checkLoaded();
        return this.value.getLongValue();
    }

    public void setParameterBounds(long lowerBound, long upperBound) {
        super.setParameterBounds(lowerBound, upperBound);
    }

    @Override
    YoLong getVariable() {
        return this.value;
    }

    @Override
    void setToDefault() {
        this.value.set(this.initialValue);
    }

    private class YoLongParameter
    extends YoLong {
        public YoLongParameter(String name, String description, YoRegistry registry) {
            super(name, description, registry);
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public LongParameter getParameter() {
            return LongParameter.this;
        }

        @Override
        public YoLong duplicate(YoRegistry newRegistry) {
            LongParameter newParameter = new LongParameter(this.getName(), this.getDescription(), newRegistry, LongParameter.this.initialValue, (long)this.getLowerBound(), (long)this.getUpperBound());
            newParameter.value.set(LongParameter.this.value.getValue());
            newParameter.loadStatus = LongParameter.this.getLoadStatus();
            return newParameter.value;
        }
    }
}

