/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoLongTest {
    private YoRegistry registry;
    private Random random;
    private YoLong yoLong;
    private static final double EPSILON = 1.0E-10;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.random = new Random(1776L);
        this.yoLong = new YoLong("test", this.registry);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoLong = null;
    }

    @Test
    public void testSetAndGet() {
        for (int i = 0; i < 100; ++i) {
            long value = this.random.nextLong();
            boolean notify = this.random.nextBoolean();
            this.yoLong.set(value, notify);
            Assertions.assertEquals((long)value, (long)this.yoLong.getLongValue());
        }
    }

    @Test
    public void testIncrementDecrementAddSubtract() {
        long value = this.random.nextLong();
        this.yoLong.set(value);
        this.yoLong.increment();
        Assertions.assertEquals((long)(value + 1L), (long)this.yoLong.getLongValue());
        this.yoLong.decrement();
        Assertions.assertEquals((long)value, (long)this.yoLong.getLongValue());
        this.yoLong.add(value);
        Assertions.assertEquals((long)(value * 2L), (long)this.yoLong.getLongValue());
        this.yoLong.subtract(value);
        Assertions.assertEquals((long)value, (long)this.yoLong.getLongValue());
    }

    @Test
    public void testLargeValue() {
        long value = 0x7FFFFFFFFFFFFFFDL;
        this.yoLong.set(value);
        Assertions.assertEquals((long)value, (long)this.yoLong.getLongValue());
    }

    @Test
    public void testValueEquals() {
        Assertions.assertTrue((boolean)this.yoLong.valueEquals(0L));
        long number = this.random.nextLong();
        this.yoLong.set(number);
        Assertions.assertTrue((boolean)this.yoLong.valueEquals(number));
    }

    @Test
    public void testSetFinal() {
        Assertions.assertEquals((long)0L, (long)this.yoLong.getLongValue());
        this.yoLong.set(0L);
        Assertions.assertEquals((long)0L, (long)this.yoLong.getLongValue());
        int value = this.random.nextInt() + 1;
        this.yoLong.set((long)value);
        Assertions.assertEquals((long)value, (long)this.yoLong.getLongValue());
    }

    @Test
    public void testSetValueFromDouble() {
        double doubleValue = this.random.nextDouble();
        int intValue = (int)Math.round(doubleValue);
        boolean notifyListeners = true;
        this.yoLong.setValueFromDouble(doubleValue, notifyListeners);
        Assertions.assertEquals((long)intValue, (long)this.yoLong.getLongValue());
    }

    @Test
    public void testGetValueAsDouble() {
        Assertions.assertEquals((double)0.0, (double)this.yoLong.getValueAsDouble(), (double)1.0E-10);
        long value = 15L;
        this.yoLong.set(value);
        double result = this.yoLong.getValueAsDouble();
        Assertions.assertEquals((double)15.0, (double)result, (double)1.0E-10);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)(this.yoLong.getName() + ": " + this.yoLong.getLongValue()), (Object)this.yoLong.toString());
    }

    @Test
    public void testGetYoVariableType() {
        Assertions.assertEquals((Object)YoVariableType.LONG, (Object)this.yoLong.getType());
    }

    @Test
    public void testGetAndSetValueAsLongBits() {
        int value = 57;
        this.yoLong.set((long)value);
        long result = this.yoLong.getValueAsLongBits();
        Assertions.assertEquals((long)value, (long)result);
        long longValue = 12345L;
        boolean notifyListeners = true;
        this.yoLong.setValueFromLongBits(longValue, notifyListeners);
        Assertions.assertEquals((long)longValue, (long)this.yoLong.getValueAsLongBits());
    }

    @Test
    public void testDuplicate() {
        YoLong yoLong2 = new YoLong("var2", "descriptionTest", this.registry);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoLong duplicate = yoLong2.duplicate(newRegistry);
        Assertions.assertEquals((Object)yoLong2.getName(), (Object)duplicate.getName());
        Assertions.assertEquals((Object)yoLong2.getDescription(), (Object)duplicate.getDescription());
        Assertions.assertEquals((double)yoLong2.getLowerBound(), (double)duplicate.getLowerBound(), (double)1.0E-10);
        Assertions.assertEquals((double)yoLong2.getUpperBound(), (double)duplicate.getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testProviderValue() {
        this.yoLong.set(0x4FFFFFFF6L);
        Assertions.assertEquals((long)this.yoLong.getLongValue(), (long)this.yoLong.getValue());
        this.yoLong.set(-21474836480L);
        Assertions.assertEquals((long)this.yoLong.getLongValue(), (long)this.yoLong.getValue());
    }
}

