/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DoubleParameterTest {
    private static final double initialValue = 42.0;

    public DoubleParameter createParameterWithNamespace() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry a = new YoRegistry("a");
        YoRegistry b = new YoRegistry("b");
        YoRegistry c = new YoRegistry("c");
        root.addChild(a);
        a.addChild(b);
        b.addChild(c);
        DoubleParameter param = new DoubleParameter("param", "paramDescription", c, 42.0, -20.3, 24.5);
        return param;
    }

    @Test
    public void testConstructDefaultValue() {
        YoRegistry dummy = new YoRegistry("dummy");
        DoubleParameter test = new DoubleParameter("test", dummy);
        test.loadDefault();
        Assertions.assertTrue((boolean)Double.isNaN(test.getValue()));
    }

    @Test
    public void testDuplicate() {
        DoubleParameter param = this.createParameterWithNamespace();
        YoDouble var = param.getVariable();
        param.loadDefault();
        var.set(632.0);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoDouble newVar = var.duplicate(newRegistry);
        DoubleParameter newParam = (DoubleParameter)newVar.getParameter();
        Assertions.assertEquals((Object)param.getName(), (Object)newParam.getName());
        Assertions.assertEquals((Object)param.getDescription(), (Object)newParam.getDescription());
        Assertions.assertEquals((double)param.getValue(), (double)newParam.getValue(), (double)1.0E-9);
        Assertions.assertEquals((double)var.getLowerBound(), (double)newVar.getLowerBound(), (double)1.0E-9);
        Assertions.assertEquals((double)var.getUpperBound(), (double)newVar.getUpperBound(), (double)1.0E-9);
    }

    @Test
    public void testGetNamespace() {
        DoubleParameter param = this.createParameterWithNamespace();
        Assertions.assertEquals((Object)"root.a.b.c", (Object)param.getNamespace().toString());
        Assertions.assertEquals((Object)"param", (Object)param.getName());
    }

    @Test
    public void testLoadFromString() {
        for (double s = 0.0; s < 100.0; s += 1.153165) {
            YoRegistry dummy = new YoRegistry("dummy");
            DoubleParameter param = new DoubleParameter("test", dummy);
            param.load(String.valueOf(s));
            Assertions.assertEquals((double)s, (double)param.getValue(), (double)1.0E-9);
            Assertions.assertEquals((Object)String.valueOf(s), (Object)param.getValueAsString());
        }
    }

    @Test
    public void testGetBeforeLoad() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            DoubleParameter param = this.createParameterWithNamespace();
            param.getValue();
        });
    }

    @Test
    public void testDefault() {
        DoubleParameter param = this.createParameterWithNamespace();
        param.loadDefault();
        Assertions.assertEquals((double)42.0, (double)param.getValue(), (double)1.0E-9);
    }

    @Test
    public void testListener() {
        DoubleParameter param = this.createParameterWithNamespace();
        CallbackTest callback = new CallbackTest();
        param.addListener((YoParameterChangedListener)callback);
        Assertions.assertFalse((boolean)callback.set);
        param.loadDefault();
        callback.set = false;
        param.getVariable().setValueFromDouble(param.getVariable().getValueAsDouble());
        Assertions.assertFalse((boolean)callback.set);
        param.getVariable().setValueFromDouble(1.0);
        Assertions.assertTrue((boolean)callback.set);
    }

    private class CallbackTest
    implements YoParameterChangedListener {
        boolean set = false;

        private CallbackTest() {
        }

        public void changed(YoParameter v) {
            this.set = true;
        }
    }
}

