/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameQuaternionReadOnlyTest;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.QuaternionBasicsTest;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoVariable;

public final class YoMutableFrameQuaternionTest
extends FrameQuaternionReadOnlyTest<YoMutableFrameQuaternion> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final double EPSILON = 1.0E-10;

    public YoMutableFrameQuaternion createFrameTuple(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4DReadOnly) {
        if (tuple4DReadOnly instanceof QuaternionReadOnly) {
            return new YoMutableFrameQuaternion("", "", null, referenceFrame, (QuaternionReadOnly)tuple4DReadOnly);
        }
        return new YoMutableFrameQuaternion("", "", null, referenceFrame, tuple4DReadOnly);
    }

    public YoMutableFrameQuaternion createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        Quaternion quaternion = new Quaternion();
        quaternion.setUnsafe(x, y, z, s);
        return new YoMutableFrameQuaternion("", "", null, referenceFrame, (QuaternionReadOnly)quaternion);
    }

    @Test
    public void testMutableFrameObject() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        YoMutableFrameQuaternion mutableFrameObject = new YoMutableFrameQuaternion("", "", registry);
        YoVariable frameIndex = registry.findVariable(YoGeometryNameTools.assembleName((String[])new String[]{"", "frame", ""}));
        Assertions.assertNotNull((Object)frameIndex);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frame = (ReferenceFrame)frames.get(random.nextInt(frames.size()));
            mutableFrameObject.setReferenceFrame(frame);
            Assertions.assertTrue((frame == mutableFrameObject.getReferenceFrame() ? 1 : 0) != 0);
            if (frame == null) {
                Assertions.assertEquals((long)-1L, (long)frameIndex.getValueAsLongBits());
                continue;
            }
            Assertions.assertEquals((long)frame.getFrameIndex(), (long)frameIndex.getValueAsLongBits());
        }
    }

    @Test
    public void testConstructors() throws Exception {
        Quaternion expectedQuaternion;
        YoMutableFrameQuaternion YoMutableFrameQuaternion2;
        YoMutableFrameQuaternion YoMutableFrameQuaternion3;
        Quaternion randomQuaternion;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        YoMutableFrameQuaternion YoMutableFrameQuaternion4 = new YoMutableFrameQuaternion("", "", null);
        Assertions.assertTrue((YoMutableFrameQuaternion4.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)YoMutableFrameQuaternion4);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion YoMutableFrameQuaternion5 = new YoMutableFrameQuaternion("", "", null, randomFrame);
            Assertions.assertTrue((YoMutableFrameQuaternion5.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)YoMutableFrameQuaternion5);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion3 = new YoMutableFrameQuaternion("", "", null, randomFrame, (randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random)).getX(), randomQuaternion.getY(), randomQuaternion.getZ(), randomQuaternion.getS());
            Assertions.assertTrue((YoMutableFrameQuaternion3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double[] array = new double[4];
            randomQuaternion.get(array);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, array);
            Assertions.assertTrue((YoMutableFrameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 1);
            randomQuaternion.get((DMatrix)denseMatrix);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, (DMatrix)denseMatrix);
            Assertions.assertTrue((YoMutableFrameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion3 = new YoMutableFrameQuaternion("", "", null, randomFrame, (QuaternionReadOnly)(randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random)));
            Assertions.assertTrue((YoMutableFrameQuaternion3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector4D randomTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            expectedQuaternion = new Quaternion((Tuple4DReadOnly)randomTuple);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, (Tuple4DReadOnly)randomTuple);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            RotationMatrix randomRotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expectedQuaternion = new Quaternion((Orientation3DReadOnly)randomRotationMatrix);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, (Orientation3DReadOnly)randomRotationMatrix);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            AxisAngle randomAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expectedQuaternion = new Quaternion((Orientation3DReadOnly)randomAxisAngle);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, (Orientation3DReadOnly)randomAxisAngle);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomRotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedQuaternion = new Quaternion((Vector3DReadOnly)randomRotationVector);
            YoMutableFrameQuaternion2 = new YoMutableFrameQuaternion("", "", null, randomFrame, (Vector3DReadOnly)randomRotationVector);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Quaternion expectedQuaternion2 = new Quaternion(yaw, pitch, roll);
            YoMutableFrameQuaternion YoMutableFrameQuaternion6 = new YoMutableFrameQuaternion("", "", null, randomFrame, yaw, pitch, roll);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedQuaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion6, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion randomFrameTuple4D = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFrameQuaternion3 = new YoMutableFrameQuaternion("", "", null, (FrameTuple4DReadOnly)randomFrameTuple4D);
            Assertions.assertTrue((YoMutableFrameQuaternion3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomFrameTuple4D, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple4DEquals((FrameTuple4DReadOnly)randomFrameTuple4D, (FrameTuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion randomFrameQuaternion = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFrameQuaternion3 = new YoMutableFrameQuaternion("", "", null, (FrameQuaternionReadOnly)randomFrameQuaternion);
            Assertions.assertTrue((YoMutableFrameQuaternion3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomFrameQuaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple4DEquals((FrameTuple4DReadOnly)randomFrameQuaternion, (FrameTuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Quaternion expectedGeometryObject = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expectedGeometryObject.setToZero();
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YoMutableFrameQuaternion frameGeometryObject = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((Tuple4DReadOnly)frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero();
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedGeometryObject, (Tuple4DReadOnly)frameGeometryObject, (double)1.0E-10);
            frameGeometryObject = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((Tuple4DReadOnly)frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expectedGeometryObject, (Tuple4DReadOnly)frameGeometryObject, (double)1.0E-10);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(574L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YoMutableFrameQuaternion frameGeometryObject = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN();
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)frameGeometryObject);
            frameGeometryObject = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)frameGeometryObject);
        }
    }

    @Test
    public void testMatchingFrame() throws Exception {
        YoMutableFrameQuaternion actual;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        Random random = new Random(3225L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion expected = this.createFrameTuple(sourceFrame, (Tuple4DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            actual = (YoMutableFrameQuaternion)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameQuaternionReadOnly)expected);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple4DEquals((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion source = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)sourceFrame);
            actual = this.createFrameTuple(destinationFrame, (Tuple4DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            actual.setMatchingFrame((FrameTuple4DReadOnly)source);
            YoMutableFrameQuaternion expected = new YoMutableFrameQuaternion("", "", null, (FrameTuple4DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple4DEquals((FrameTuple4DReadOnly)expected, (FrameTuple4DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        Quaternion quaternion;
        YoMutableFrameQuaternion YoMutableFrameQuaternion2;
        ReferenceFrame newFrame;
        Quaternion quaternion2;
        YoMutableFrameQuaternion YoMutableFrameQuaternion3;
        ReferenceFrame newFrame2;
        int i;
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion3 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            YoMutableFrameQuaternion3.setIncludingFrame(newFrame2, (Orientation3DReadOnly)axisAngle);
            quaternion2.set((Orientation3DReadOnly)axisAngle);
            Assertions.assertEquals((Object)newFrame2, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion3 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            YoMutableFrameQuaternion3.setIncludingFrame(newFrame2, (Orientation3DReadOnly)rotationMatrix);
            quaternion2.set((Orientation3DReadOnly)rotationMatrix);
            Assertions.assertEquals((Object)newFrame2, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion3 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            YoMutableFrameQuaternion3.setRotationVectorIncludingFrame(newFrame2, (Vector3DReadOnly)rotationVector);
            quaternion2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame2, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D rotationVector = new FrameVector3D(newFrame3, (Tuple3DReadOnly)EuclidCoreRandomTools.nextRotationVector((Random)random));
            YoMutableFrameQuaternion3 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            YoMutableFrameQuaternion3.setRotationVectorIncludingFrame((FrameVector3DReadOnly)rotationVector);
            quaternion2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame3, (Object)YoMutableFrameQuaternion3.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion2 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion2.getReferenceFrame());
            YoMutableFrameQuaternion2.setYawPitchRollIncludingFrame(newFrame, yaw, pitch, roll);
            quaternion.setYawPitchRoll(yaw, pitch, roll);
            Assertions.assertEquals((Object)newFrame, (Object)YoMutableFrameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
            eulerAngles.setY(EuclidCoreTools.clamp((double)eulerAngles.getY(), (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE));
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion YoMutableFrameQuaternion4 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion4.getReferenceFrame());
            YoMutableFrameQuaternion4.setEulerIncludingFrame(newFrame2, (Vector3DReadOnly)eulerAngles);
            quaternion2.setEuler((Vector3DReadOnly)eulerAngles);
            Assertions.assertEquals((Object)newFrame2, (Object)YoMutableFrameQuaternion4.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion2, (Tuple4DReadOnly)YoMutableFrameQuaternion4, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double rotX = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double rotY = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double rotZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameQuaternion2 = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)YoMutableFrameQuaternion2.getReferenceFrame());
            YoMutableFrameQuaternion2.setEulerIncludingFrame(newFrame, rotX, rotY, rotZ);
            quaternion.setEuler(rotX, rotY, rotZ);
            Assertions.assertEquals((Object)newFrame, (Object)YoMutableFrameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)quaternion, (Tuple4DReadOnly)YoMutableFrameQuaternion2, (double)1.0E-10);
        }
    }

    @Test
    public void testConsistencyWithQuaternion() {
        FrameTypeCopier frameTypeBuilder = (frame, quaternion) -> this.createFrameTuple(frame, (Tuple4DReadOnly)((QuaternionReadOnly)quaternion));
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidCoreRandomTools::nextQuaternion;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
        RandomFramelessTypeBuilder frameless2DTypeBuilder = random -> new Quaternion((QuaternionReadOnly)this.createRandom2DFrameTuple(random, ReferenceFrame.getWorldFrame()));
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, frameless2DTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Quaternion.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Quaternion.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Quaternion.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(YoMutableFrameQuaternion.class, Quaternion.class, true, 1, methodFilter);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            YoMutableFrameQuaternion quaternion = new YoMutableFrameQuaternion("", "", null, initialFrame, (QuaternionReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            quaternion.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == quaternion.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)quaternion, (double)1.0E-10);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                quaternion.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSet() throws Exception {
        Random random = new Random(3452L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            int initialFrameIndex = random.nextInt(referenceFrames.length);
            ReferenceFrame initialFrame = referenceFrames[initialFrameIndex];
            YoMutableFrameQuaternion actual = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple4DReadOnly)actual, 1.0E-10));
            actual.set(initialFrame, (QuaternionReadOnly)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple4DReadOnly)actual, 1.0E-10));
            expected.set((QuaternionReadOnly)actual);
            int differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            ReferenceFrame differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YoMutableFrameQuaternion expected = (YoMutableFrameQuaternion)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            YoMutableFrameQuaternion actual = (YoMutableFrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            YoMutableFrameQuaternion frameQuaternion1 = this.createFrameTuple(worldFrame, (Tuple4DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            YoMutableFrameQuaternion frameQuaternion2 = new YoMutableFrameQuaternion("", "", null, worldFrame);
            double epsilon = random.nextDouble();
            AxisAngle axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.99 * epsilon);
            Quaternion difference = new Quaternion((Orientation3DReadOnly)axisAngleDiff);
            frameQuaternion2.multiply((FrameQuaternionReadOnly)frameQuaternion1, (QuaternionReadOnly)difference);
            Assertions.assertTrue((boolean)frameQuaternion1.geometricallyEquals((FrameQuaternionReadOnly)frameQuaternion2, epsilon));
            axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 1.01 * epsilon);
            difference = new Quaternion((Orientation3DReadOnly)axisAngleDiff);
            frameQuaternion2.multiply((FrameQuaternionReadOnly)frameQuaternion1, (QuaternionReadOnly)difference);
            Assertions.assertFalse((boolean)frameQuaternion1.geometricallyEquals((FrameQuaternionReadOnly)frameQuaternion2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(763L);
        for (int i = 0; i < 1000; ++i) {
            FrameQuaternion expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            YoMutableFrameQuaternion actual = new YoMutableFrameQuaternion("", "", null, worldFrame, (QuaternionReadOnly)expected);
            Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        }
    }

    @Test
    public void testQuaternionBasicsFeatures() throws Exception {
        QuaternionBasicsTest<YoMutableFrameQuaternion> quaternionBasicsTest = new QuaternionBasicsTest<YoMutableFrameQuaternion>(){

            public YoMutableFrameQuaternion createEmptyTuple() {
                return new YoMutableFrameQuaternion("", "", null);
            }

            public YoMutableFrameQuaternion createTuple(double v, double v1, double v2, double v3) {
                YoMutableFrameQuaternion ret = new YoMutableFrameQuaternion("", "", null, ReferenceFrame.getWorldFrame());
                ret.setUnsafe(v, v1, v2, v3);
                return ret;
            }

            public YoMutableFrameQuaternion createRandomTuple(Random random) {
                return new YoMutableFrameQuaternion("", "", null, ReferenceFrame.getWorldFrame(), (QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            }

            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : quaternionBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)quaternionBasicsTest, new Object[0]);
        }
    }
}

