/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple2DBasicsTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoMutableFramePoint2DTest
extends FrameTuple2DBasicsTest<YoMutableFramePoint2D> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    public Tuple2DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint2D((Random)random);
    }

    public YoMutableFramePoint2D createFrameTuple(ReferenceFrame referenceFrame, double x, double y) {
        return new YoMutableFramePoint2D("", "", null, referenceFrame, x, y);
    }

    @Test
    public void testMutableFrameObject() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        YoMutableFramePoint2D mutableFrameObject = new YoMutableFramePoint2D("", "", registry);
        YoVariable frameIndex = registry.findVariable(YoGeometryNameTools.assembleName((String[])new String[]{"", "frame", ""}));
        Assertions.assertNotNull((Object)frameIndex);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frame = (ReferenceFrame)frames.get(random.nextInt(frames.size()));
            mutableFrameObject.setReferenceFrame(frame);
            Assertions.assertTrue((frame == mutableFrameObject.getReferenceFrame() ? 1 : 0) != 0);
            if (frame == null) {
                Assertions.assertEquals((long)-1L, (long)frameIndex.getValueAsLongBits());
                continue;
            }
            Assertions.assertEquals((long)frame.getFrameIndex(), (long)frameIndex.getValueAsLongBits());
        }
    }

    @Test
    public void testConstructors() throws Exception {
        YoMutableFramePoint2D YoMutableFramePoint2D2;
        Point2D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        YoMutableFramePoint2D YoMutableFramePoint2D3 = new YoMutableFramePoint2D("", "", null);
        Assertions.assertTrue((YoMutableFramePoint2D3.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)YoMutableFramePoint2D3);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint2D YoMutableFramePoint2D4 = new YoMutableFramePoint2D("", "", null, randomFrame);
            Assertions.assertTrue((YoMutableFramePoint2D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)YoMutableFramePoint2D4);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint2D2 = new YoMutableFramePoint2D("", "", null, randomFrame, (randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random)).getX(), randomTuple.getY());
            Assertions.assertTrue((YoMutableFramePoint2D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple, (Tuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            YoMutableFramePoint2D YoMutableFramePoint2D5 = new YoMutableFramePoint2D("", "", null, randomFrame, array);
            Assertions.assertTrue((YoMutableFramePoint2D5.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple, (Tuple2DReadOnly)YoMutableFramePoint2D5, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint2D2 = new YoMutableFramePoint2D("", "", null, randomFrame, (Tuple2DReadOnly)(randomTuple = EuclidCoreRandomTools.nextPoint2D((Random)random)));
            Assertions.assertTrue((YoMutableFramePoint2D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple, (Tuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D randomTuple3D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint2D2 = new YoMutableFramePoint2D("", "", null, randomFrame, (Tuple3DReadOnly)(randomTuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random)));
            Assertions.assertTrue((YoMutableFramePoint2D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)randomTuple3D), (Tuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint3D randomFrameTuple3D = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFramePoint2D2 = new YoMutableFramePoint2D("", "", null, (FrameTuple3DReadOnly)randomFrameTuple3D);
            Assertions.assertTrue((YoMutableFramePoint2D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)randomFrameTuple3D), (Tuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFramePoint2D2 = new YoMutableFramePoint2D("", "", null, (FrameTuple2DReadOnly)randomTuple);
            Assertions.assertTrue((YoMutableFramePoint2D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple, (Tuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
            EuclidFrameTestTools.assertFrameTuple2DEquals((FrameTuple2DReadOnly)randomTuple, (FrameTuple2DReadOnly)YoMutableFramePoint2D2, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        Random random = new Random(544354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FramePoint2D source = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)sourceFrame);
            YoMutableFramePoint2D actual = (YoMutableFramePoint2D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source);
            YoMutableFramePoint2D expected = new YoMutableFramePoint2D("", "", null, (FrameTuple2DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple2DEquals((FrameTuple2DReadOnly)expected, (FrameTuple2DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (boolean)true);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Point2D expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
            YoMutableFramePoint2D actual = new YoMutableFramePoint2D("", "", null, initialFrame, (Tuple2DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testChangeFrameAndProjectToXYPlane() throws Exception {
        Random random = new Random(345345L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Point2D expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
            YoMutableFramePoint2D actual = new YoMutableFramePoint2D("", "", null, initialFrame, (Tuple2DReadOnly)expected);
            expected.applyTransform((Transform)initialFrame.getTransformToDesiredFrame(newFrame), false);
            actual.changeFrameAndProjectToXYPlane(newFrame);
            Assertions.assertTrue((newFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (boolean)true);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YoMutableFramePoint2D expected = (YoMutableFramePoint2D)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            YoMutableFramePoint2D actual = (YoMutableFramePoint2D)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            YoMutableFramePoint2D framePoint1 = (YoMutableFramePoint2D)this.createRandomFrameTuple(random, worldFrame);
            YoMutableFramePoint2D framePoint2 = new YoMutableFramePoint2D("", "", null, worldFrame);
            double epsilon = random.nextDouble();
            Vector2D difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            framePoint2.add((FrameTuple2DReadOnly)framePoint1, (Tuple2DReadOnly)difference);
            Assertions.assertTrue((boolean)framePoint1.geometricallyEquals((FramePoint2DReadOnly)framePoint2, epsilon));
            difference = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            framePoint2.add((FrameTuple2DReadOnly)framePoint1, (Tuple2DReadOnly)difference);
            Assertions.assertFalse((boolean)framePoint1.geometricallyEquals((FramePoint2DReadOnly)framePoint2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(763L);
        for (int i = 0; i < 1000; ++i) {
            FramePoint2D expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame, (double)-1.0E15, (double)1.0E15);
            YoMutableFramePoint2D actual = new YoMutableFramePoint2D("", "", null, worldFrame, (Tuple2DReadOnly)expected);
            Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        }
    }

    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Point2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Point2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Point2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(YoMutableFramePoint2D.class, Point2D.class, true, 1, methodFilter);
    }
}

