/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.buffer.YoBufferBounds;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBufferVariableEntryTest {
    private YoDouble yoDouble;
    private YoBufferVariableEntry dataBufferEntry;
    private int nPoints = 10000;

    @BeforeEach
    public void setup() {
        this.yoDouble = new YoDouble("yoDouble", null);
        this.yoDouble.set(0.0);
        this.dataBufferEntry = new YoBufferVariableEntry((YoVariable)this.yoDouble, this.nPoints);
    }

    @AfterEach
    public void tearDown() {
        this.yoDouble = null;
        this.dataBufferEntry = null;
    }

    @Test
    public void testTickAndUpdate() {
        Random random = new Random(1345143L);
        double epsilon = 0.0;
        double[] tempData = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        double[] data = this.dataBufferEntry.getBuffer();
        for (int i = 0; i < this.nPoints; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)data[i], (double)epsilon);
        }
    }

    @Test
    public void testComputeAverage() {
        Random random = new Random(768439L);
        double lowerBound = -100.0;
        double upperBound = 100.0;
        double total = 0.0;
        for (int i = 0; i < this.nPoints; ++i) {
            double data = random.nextDouble() * (upperBound - lowerBound) + lowerBound;
            this.yoDouble.set(data);
            total += data;
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        double average = total / (double)this.nPoints;
        double computedAverage = this.dataBufferEntry.computeAverage();
        Assertions.assertEquals((double)average, (double)computedAverage, (double)1.0E-7);
    }

    @Test
    public void testUpdateValue() {
        int i;
        Random random = new Random(754380L);
        double epsilon = 0.0;
        double[] tempData = new double[this.nPoints];
        for (i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        for (i = 0; i < this.nPoints; ++i) {
            this.dataBufferEntry.readFromBufferAt(i);
            Assertions.assertEquals((double)this.yoDouble.getValueAsDouble(), (double)this.dataBufferEntry.getBuffer()[i], (double)epsilon);
        }
    }

    @Test
    public void testCheckIfDataIsEqual() {
        double temp;
        int i;
        Random random = new Random(32890L);
        double epsilon = 0.0;
        YoDouble yoDouble2 = new YoDouble("yoDouble", null);
        yoDouble2.set(0.0);
        YoBufferVariableEntry entry2 = new YoBufferVariableEntry((YoVariable)yoDouble2, this.nPoints);
        for (i = 0; i < this.nPoints; ++i) {
            temp = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(temp);
            yoDouble2.set(temp);
            this.dataBufferEntry.writeIntoBufferAt(i);
            entry2.writeIntoBufferAt(i);
        }
        Assertions.assertTrue((boolean)this.dataBufferEntry.epsilonEquals(entry2, epsilon));
        entry2 = null;
        this.dataBufferEntry = null;
        this.dataBufferEntry = new YoBufferVariableEntry((YoVariable)this.yoDouble, this.nPoints);
        entry2 = new YoBufferVariableEntry((YoVariable)yoDouble2, this.nPoints);
        for (i = 0; i < this.nPoints; ++i) {
            temp = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(temp);
            yoDouble2.set(-temp);
            this.dataBufferEntry.writeIntoBufferAt(i);
            entry2.writeIntoBufferAt(i);
        }
        Assertions.assertFalse((boolean)this.dataBufferEntry.epsilonEquals(entry2, epsilon));
    }

    @Test
    public void testGetMinAndMaxScaling() {
        Random random = new Random(80423L);
        double minScaling = random.nextDouble();
        double maxScaling = random.nextDouble() + 2.0;
        this.dataBufferEntry.setCustomBounds(minScaling, maxScaling);
        Assertions.assertEquals((double)minScaling, (double)this.dataBufferEntry.getCustomLowerBound(), (double)0.0);
        Assertions.assertEquals((double)maxScaling, (double)this.dataBufferEntry.getCustomUpperBound(), (double)0.0);
    }

    @Test
    public void testGetVariable() {
        Assertions.assertEquals((Object)this.yoDouble, (Object)this.dataBufferEntry.getVariable());
    }

    @Test
    public void testCopyValueThrough() {
        Random random = new Random(2346180L);
        double tempDouble = random.nextDouble();
        this.yoDouble.set(tempDouble);
        this.dataBufferEntry.writeIntoBufferAt(0);
        this.dataBufferEntry.fillBuffer();
        for (int i = 0; i < this.nPoints; ++i) {
            Assertions.assertEquals((double)tempDouble, (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
    }

    @Test
    public void testEnlargeBufferSize() {
        int i;
        Random random = new Random(324270L);
        double[] tempData = new double[this.nPoints];
        int newSizeDelta = random.nextInt(100);
        for (i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        this.dataBufferEntry.enlargeBufferSize(this.nPoints + newSizeDelta);
        Assertions.assertEquals((int)(this.nPoints + newSizeDelta), (int)this.dataBufferEntry.getBuffer().length);
        for (i = 0; i < this.nPoints; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
    }

    @Test
    public void testCropData() {
        int i;
        Random random = new Random(2372891L);
        double[] tempData = new double[this.nPoints];
        for (i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        Assertions.assertEquals((int)-1, (int)this.dataBufferEntry.cropBuffer(-1, this.nPoints));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        Assertions.assertEquals((int)-1, (int)this.dataBufferEntry.cropBuffer(0, this.nPoints + 1));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.cropBuffer(0, this.nPoints - 1));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        for (i = 0; i < this.nPoints; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        Assertions.assertEquals((int)(this.nPoints - 100), (int)this.dataBufferEntry.cropBuffer(0, this.nPoints - 101));
        for (i = 0; i < this.nPoints - 100; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        this.dataBufferEntry.enlargeBufferSize(this.nPoints);
        for (i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        Assertions.assertEquals((int)(this.nPoints - 100), (int)this.dataBufferEntry.cropBuffer(100, this.nPoints - 1));
        for (i = 0; i < this.dataBufferEntry.getBuffer().length; ++i) {
            Assertions.assertEquals((double)tempData[100 + i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
    }

    @Test
    public void testCutData() {
        int i;
        int i2;
        Random random = new Random(1230972L);
        double[] tempData = new double[this.nPoints];
        for (i2 = 0; i2 < this.nPoints; ++i2) {
            tempData[i2] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i2]);
            this.dataBufferEntry.writeIntoBufferAt(i2);
        }
        Assertions.assertEquals((int)-1, (int)this.dataBufferEntry.cropBuffer(-1, this.nPoints));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        Assertions.assertEquals((int)-1, (int)this.dataBufferEntry.cropBuffer(0, this.nPoints + 1));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        Assertions.assertEquals((int)-1, (int)this.dataBufferEntry.cutBuffer(this.nPoints / 2 + 1, this.nPoints / 2 - 1));
        Assertions.assertEquals((int)this.nPoints, (int)this.dataBufferEntry.getBuffer().length);
        for (i2 = 0; i2 < this.nPoints; ++i2) {
            Assertions.assertEquals((double)tempData[i2], (double)this.dataBufferEntry.getBuffer()[i2], (double)0.0);
        }
        int cutPoint = this.nPoints / 2;
        int sizeAfterCut = this.dataBufferEntry.cutBuffer(cutPoint, cutPoint);
        Assertions.assertEquals((int)(this.nPoints - 1), (int)sizeAfterCut);
        Assertions.assertEquals((int)(this.nPoints - 1), (int)this.dataBufferEntry.getBuffer().length);
        for (i = 0; i < cutPoint; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        for (i = cutPoint; i < this.nPoints - 1; ++i) {
            Assertions.assertEquals((double)tempData[i + 1], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        this.dataBufferEntry.enlargeBufferSize(this.nPoints);
        for (i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        sizeAfterCut = this.dataBufferEntry.cutBuffer(0, 2);
        Assertions.assertEquals((int)(this.nPoints - 3), (int)sizeAfterCut);
        for (i = 0; i < this.nPoints - 3; ++i) {
            Assertions.assertEquals((double)tempData[i + 3], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        this.dataBufferEntry.enlargeBufferSize(this.nPoints);
        for (i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        sizeAfterCut = this.dataBufferEntry.cutBuffer(this.nPoints - 3, this.nPoints - 1);
        Assertions.assertEquals((int)(this.nPoints - 3), (int)sizeAfterCut);
        for (i = 0; i < this.dataBufferEntry.getBuffer().length; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
    }

    @Test
    public void testPackData() {
        int i;
        Random random = new Random(4357684L);
        double[] tempData = new double[this.nPoints];
        int newStartIndex = random.nextInt(this.nPoints - 1);
        for (i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        this.dataBufferEntry.shiftBuffer(-1);
        for (i = 0; i < this.nPoints - 100; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        this.dataBufferEntry.shiftBuffer(this.nPoints + 10);
        for (i = 0; i < this.nPoints - 100; ++i) {
            Assertions.assertEquals((double)tempData[i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
        this.dataBufferEntry.shiftBuffer(newStartIndex);
        for (i = 0; i < this.nPoints - 1 - newStartIndex; ++i) {
            Assertions.assertEquals((double)tempData[newStartIndex + i], (double)this.dataBufferEntry.getBuffer()[i], (double)0.0);
        }
    }

    @Test
    public void testGetMax() {
        Random random = new Random(6789423L);
        int tempInteger = random.nextInt(500) + 11;
        this.yoDouble.set((double)tempInteger);
        this.dataBufferEntry.writeIntoBufferAt(0);
        this.yoDouble.set((double)(tempInteger + 10));
        this.dataBufferEntry.writeIntoBufferAt(1);
        this.yoDouble.set((double)(tempInteger - 10));
        this.dataBufferEntry.writeIntoBufferAt(2);
        Assertions.assertEquals((double)(tempInteger + 10), (double)this.dataBufferEntry.getUpperBound(), (double)0.0);
    }

    @Test
    public void testGetMin() {
        Random random = new Random(213705602L);
        int tempInteger = random.nextInt(500) + 11;
        this.yoDouble.set((double)tempInteger);
        this.dataBufferEntry.writeIntoBufferAt(0);
        this.yoDouble.set((double)(tempInteger + 10));
        this.dataBufferEntry.writeIntoBufferAt(1);
        this.yoDouble.set((double)(tempInteger - 10));
        this.dataBufferEntry.writeIntoBufferAt(2);
        Assertions.assertEquals((double)0.0, (double)this.dataBufferEntry.getBounds().getLowerBound(), (double)0.0);
    }

    @Test
    public void testMinMaxWithNaN() {
        for (int i = 0; i < 100; ++i) {
            this.yoDouble.set(Double.NaN);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        Assertions.assertEquals((double)0.0, (double)this.dataBufferEntry.getBounds().getLowerBound(), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)this.dataBufferEntry.getBounds().getUpperBound(), (double)0.0);
    }

    @Test
    public void testMinMaxWithNaN2() {
        Random random = new Random(23785L);
        for (int i = 0; i < 100; ++i) {
            if (i == 50) {
                this.yoDouble.set(Double.NaN);
            } else {
                this.yoDouble.set(random.nextDouble());
            }
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        YoBufferBounds bounds = this.dataBufferEntry.getBounds();
        Assertions.assertFalse((boolean)Double.isNaN(bounds.getLowerBound()));
        Assertions.assertFalse((boolean)Double.isNaN(bounds.getUpperBound()));
        Assertions.assertTrue((bounds.getLowerBound() <= bounds.getUpperBound() ? 1 : 0) != 0);
    }

    @Test
    public void testResetMinMaxChanged() {
        Random random = new Random(90237L);
        int tempInteger = random.nextInt(500) + 11;
        this.yoDouble.set((double)tempInteger);
        this.dataBufferEntry.writeIntoBufferAt(0);
        Assertions.assertTrue((boolean)this.dataBufferEntry.haveBoundsChanged());
        this.dataBufferEntry.resetBoundsChangedFlag();
        Assertions.assertFalse((boolean)this.dataBufferEntry.haveBoundsChanged());
    }

    @Test
    public void testSetData() {
        Random random = new Random(23987L);
        double tempDouble = (double)random.nextInt(20000) / (double)random.nextInt(30);
        int randomIndex = random.nextInt(this.nPoints);
        this.dataBufferEntry.writeBufferAt(tempDouble, randomIndex);
        Assertions.assertEquals((double)tempDouble, (double)this.dataBufferEntry.getBuffer()[randomIndex], (double)0.0);
    }

    @Test
    public void testGetWindowedData() {
        Random random = new Random(37905L);
        double[] tempData = new double[this.nPoints];
        int randomIndex = random.nextInt(this.nPoints - 1);
        for (int i = 0; i < this.nPoints; ++i) {
            tempData[i] = (double)random.nextInt(20000) / (double)random.nextInt(30);
            this.yoDouble.set(tempData[i]);
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        double[] tempDataSubset = new double[this.nPoints - randomIndex];
        for (int i = 0; i < tempDataSubset.length; ++i) {
            tempDataSubset[i] = tempData[randomIndex + i];
        }
        double[] windowedData = this.dataBufferEntry.getBufferWindow(randomIndex, this.nPoints - randomIndex);
        for (int i = 0; i < windowedData.length; ++i) {
            Assertions.assertEquals((double)tempDataSubset[i], (double)windowedData[i], (double)0.0);
        }
    }

    @Test
    public void testEnableAutoScale() {
        this.dataBufferEntry.useCustomBounds(true);
        Assertions.assertTrue((boolean)this.dataBufferEntry.isUsingCustomBounds());
        this.dataBufferEntry.useCustomBounds(false);
        Assertions.assertFalse((boolean)this.dataBufferEntry.isUsingCustomBounds());
    }

    @Test
    public void testGetWindowBounds() {
        Random random = new Random(74839L);
        for (int i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set((double)random.nextInt(20000) / (double)random.nextInt(30));
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        double oldMax = this.dataBufferEntry.getUpperBound();
        double newMax = oldMax + 100.0;
        this.dataBufferEntry.writeBufferAt(newMax, 200);
        this.dataBufferEntry.writeBufferAt(oldMax, 400);
        Assertions.assertEquals((double)newMax, (double)this.dataBufferEntry.getWindowUpperBound(150, 250), (double)0.0);
        Assertions.assertEquals((double)oldMax, (double)this.dataBufferEntry.getWindowUpperBound(350, 450), (double)0.0);
    }

    @Test
    public void testGetMinWithParameters() {
        Random random = new Random(751290L);
        for (int i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set((double)random.nextInt(20000) / (double)random.nextInt(30));
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        double oldMin = this.dataBufferEntry.getBounds().getLowerBound();
        double newMin = oldMin - 100.0;
        this.dataBufferEntry.writeBufferAt(newMin, 200);
        this.dataBufferEntry.writeBufferAt(oldMin, 400);
        Assertions.assertEquals((double)newMin, (double)this.dataBufferEntry.getWindowLowerBound(150, 250), (double)0.0);
        Assertions.assertEquals((double)oldMin, (double)this.dataBufferEntry.getWindowLowerBound(350, 450), (double)0.0);
    }

    @Test
    public void testThinData() {
        Random random = new Random(53290L);
        for (int i = 0; i < this.nPoints; ++i) {
            this.yoDouble.set((double)random.nextInt(20000) / (double)random.nextInt(30));
            this.dataBufferEntry.writeIntoBufferAt(i);
        }
        Assertions.assertTrue((this.dataBufferEntry.getBufferSize() == this.nPoints ? 1 : 0) != 0);
        int keepEveryNthPoint = 5;
        this.dataBufferEntry.thinData(keepEveryNthPoint);
        Assertions.assertTrue((this.dataBufferEntry.getBufferSize() == this.nPoints / keepEveryNthPoint ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetInverted() {
        this.dataBufferEntry.setInverted(true);
        Assertions.assertTrue((boolean)this.dataBufferEntry.getInverted());
        this.dataBufferEntry.setInverted(false);
        Assertions.assertFalse((boolean)this.dataBufferEntry.getInverted());
    }

    @Test
    public void testGetVariableName() {
        Assertions.assertTrue((boolean)this.dataBufferEntry.getVariableName().equals(this.yoDouble.getName()));
    }

    @Test
    public void testGetFullVariableNameWithNamespace() {
        Assertions.assertTrue((boolean)this.dataBufferEntry.getVariableFullNameString().equals(this.yoDouble.getFullNameString()));
    }
}

