/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableTest {
    private YoVariable yoVariable = null;
    private YoRegistry registry = null;
    private ArrayList<TestVariableChangedListener> variableChangedListeners = null;

    @BeforeEach
    public void setUp() {
        YoRegistry robotRegistry = new YoRegistry("robot");
        this.registry = new YoRegistry("testRegistry");
        robotRegistry.addChild(this.registry);
        this.yoVariable = new YoDouble("variableOne", this.registry);
        this.variableChangedListeners = new ArrayList();
    }

    @AfterEach
    public void tearDown() {
        this.yoVariable = null;
        this.registry = null;
        this.variableChangedListeners = null;
    }

    @Test
    public void testValidVariable() {
        new YoDouble("foobar", "", null);
    }

    @Test
    public void testCantHaveADot() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo.bar", "", null));
    }

    @Test
    public void testCantHaveAComma() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo,bar", "", null));
    }

    @Test
    public void testCantHaveACarrot() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo^bar", "", null));
    }

    @Test
    public void testCanHaveAClosingBracket() {
        new YoDouble("foo]bar", "", null);
    }

    @Test
    public void testCanHaveAnOpeningBracket() {
        new YoDouble("foo[bar", "", null);
    }

    @Test
    public void testCantHaveABackSlash() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo\\bar", "", null));
    }

    @Test
    public void testCantHaveAQuote() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo\"bar", "", null));
    }

    @Test
    public void testCantHaveASpace() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo bar", "", null));
    }

    @Test
    public void testCantHaveASlash() {
        Assertions.assertThrows(RuntimeException.class, () -> new YoDouble("foo/bar", "", null));
    }

    @Test
    public void testGetBooleanValue() {
        YoBoolean booleanVariable = new YoBoolean("booleanVar", this.registry);
        booleanVariable.set(true);
        assert (booleanVariable.getBooleanValue());
        booleanVariable.set(false);
        assert (!booleanVariable.getBooleanValue());
    }

    @Test
    public void testGetDescription() {
        YoDouble descrVariable = new YoDouble("booleanVar", "Description", this.registry);
        Assertions.assertEquals((Object)descrVariable.getDescription(), (Object)"Description");
        Assertions.assertNotNull((Object)this.yoVariable.getDescription());
    }

    @Test
    public void testGetDoubleValue() {
        YoDouble doubleVariable = new YoDouble("doubleVar", this.registry);
        doubleVariable.set(15.6);
        Assertions.assertEquals((double)doubleVariable.getDoubleValue(), (double)15.6, (double)1.0E-7);
    }

    @Test
    public void testGetEnumValue() {
        YoEnum enumVariable = new YoEnum("booleanVar", this.registry, FooEnum.class);
        enumVariable.set((Enum)FooEnum.TWO);
        Assertions.assertEquals((Object)enumVariable.getEnumValue(), (Object)((Object)FooEnum.TWO));
        Assertions.assertFalse((enumVariable.getEnumValue() == FooEnum.ONE ? 1 : 0) != 0);
    }

    @Test
    public void testGetFullNameWithNamespace() {
        Assertions.assertEquals((Object)this.yoVariable.getFullName(), (Object)this.yoVariable.getRegistry().getNamespace().append(this.yoVariable.getName()));
        Assertions.assertEquals((Object)this.yoVariable.getFullNameString(), (Object)"robot.testRegistry.variableOne");
        YoRegistry newReg = new YoRegistry("newReg");
        newReg.addChild(this.yoVariable.getRegistry().getRoot());
        Assertions.assertEquals((Object)this.yoVariable.getFullName(), (Object)this.yoVariable.getRegistry().getNamespace().append(this.yoVariable.getName()));
        Assertions.assertEquals((Object)this.yoVariable.getFullNameString(), (Object)"newReg.robot.testRegistry.variableOne");
    }

    @Test
    public void testGetIntegerValue() {
        YoInteger integerVariable = new YoInteger("integerVariable", this.registry);
        integerVariable.set(5);
        Assertions.assertEquals((int)integerVariable.getIntegerValue(), (int)5);
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)this.yoVariable.getName(), (Object)"variableOne");
    }

    @Test
    public void testGetYoRegistry() {
        YoRegistry registry = this.yoVariable.getRegistry();
        Assertions.assertNotNull((Object)registry);
        Assertions.assertEquals((Object)registry, (Object)this.registry);
        Assertions.assertEquals((Object)registry.findVariable(this.yoVariable.getName()), (Object)this.yoVariable);
    }

    @Test
    public void testToString() {
        YoEnum enumyoEnum = new YoEnum("enumYoVariable", this.registry, FooEnum.class);
        enumyoEnum.set((Enum)FooEnum.THREE);
        Assertions.assertEquals((Object)"enumYoVariable: THREE", (Object)enumyoEnum.toString());
        YoInteger intyoVariable = new YoInteger("intYoVariable", this.registry);
        intyoVariable.set(1);
        Assertions.assertEquals((Object)"intYoVariable: 1", (Object)intyoVariable.toString());
        YoDouble yoVariable = new YoDouble("doubleYoVariable", this.registry);
        yoVariable.set(0.0112);
        Assertions.assertEquals((Object)"doubleYoVariable: 0.0112", (Object)yoVariable.toString());
        YoBoolean booleanyoBoolean = new YoBoolean("booleanYoVariable", this.registry);
        booleanyoBoolean.set(false);
        Assertions.assertEquals((Object)"booleanYoVariable: false", (Object)booleanyoBoolean.toString());
    }

    @Test
    public void testValueEquals() {
        YoBoolean booleanVariable = new YoBoolean("booleanVar", this.registry);
        YoDouble doubleVariable = new YoDouble("doubleVariable", this.registry);
        YoInteger intVariable = new YoInteger("intVariable", this.registry);
        YoEnum enumVariable = new YoEnum("enumVariable", this.registry, FooEnum.class);
        booleanVariable.set(true);
        doubleVariable.set(1.4);
        intVariable.set(7);
        enumVariable.set((Enum)FooEnum.THREE);
        assert (booleanVariable.valueEquals(true));
        assert (doubleVariable.valueEquals(1.4));
        assert (intVariable.valueEquals(7));
        assert (enumVariable.valueEquals((Enum)FooEnum.THREE));
        booleanVariable.set(false);
        doubleVariable.set(4.5);
        intVariable.set(9);
        enumVariable.set((Enum)FooEnum.TWO);
        assert (booleanVariable.valueEquals(false));
        assert (doubleVariable.valueEquals(4.5));
        assert (intVariable.valueEquals(9));
        assert (enumVariable.valueEquals((Enum)FooEnum.TWO));
        assert (!booleanVariable.valueEquals(true));
    }

    @Test
    public void testNotifyVaribaleChangeListeners() {
        int nObservers = 5;
        this.createVariableChangeListeners(5);
        this.yoVariable.removeListeners();
        this.addAllListenersToYoVariable();
        TestVariableChangedListener hearNoEvil = new TestVariableChangedListener();
        for (TestVariableChangedListener listener : this.variableChangedListeners) {
            Assertions.assertNull((Object)listener.getLastVariableChanged());
        }
        Assertions.assertNull((Object)hearNoEvil.getLastVariableChanged());
        this.yoVariable.notifyListeners();
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            Assertions.assertEquals((Object)observer.getLastVariableChanged(), (Object)this.yoVariable);
        }
        Assertions.assertNull((Object)hearNoEvil.getLastVariableChanged());
    }

    @Test
    public void testAddVariableChangeListener() {
        this.yoVariable.removeListeners();
        TestVariableChangedListener listener = new TestVariableChangedListener();
        this.yoVariable.addListener((YoVariableChangedListener)listener);
        this.yoVariable.removeListener((YoVariableChangedListener)listener);
    }

    @Test
    public void testRemoveAllVariableChangeListeners() {
        int nObservers = 5;
        this.createVariableChangeListeners(nObservers);
        this.addAllListenersToYoVariable();
        this.yoVariable.notifyListeners();
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            Assertions.assertEquals((Object)observer.getLastVariableChanged(), (Object)this.yoVariable);
        }
        this.yoVariable.removeListeners();
        this.resetAllObservers();
        this.yoVariable.notifyListeners();
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            Assertions.assertNull((Object)observer.getLastVariableChanged());
        }
    }

    @Test
    public void testRemoveObserver() {
        int nObservers = 5;
        this.createVariableChangeListeners(nObservers);
        this.addAllListenersToYoVariable();
        this.yoVariable.notifyListeners();
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            Assertions.assertEquals((Object)observer.getLastVariableChanged(), (Object)this.yoVariable);
        }
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            this.yoVariable.removeListener((YoVariableChangedListener)observer);
        }
        this.resetAllObservers();
        this.yoVariable.notifyListeners();
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            Assertions.assertNull((Object)observer.getLastVariableChanged());
        }
    }

    @Test
    public void testRemoveObserverNonExistent1() {
        Assertions.assertFalse((boolean)this.yoVariable.removeListener((YoVariableChangedListener)new TestVariableChangedListener()));
    }

    @Test
    public void testRemoveObserverNonExistent2() {
        this.createVariableChangeListeners(5);
        this.addAllListenersToYoVariable();
        Assertions.assertFalse((boolean)this.yoVariable.removeListener((YoVariableChangedListener)new TestVariableChangedListener()));
    }

    @Test
    public void testRecursiveCompareYoVariables() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        YoRegistry root0 = new YoRegistry("root");
        YoDouble variable01 = new YoDouble("variableOne", root0);
        YoDouble variable02 = new YoDouble("variableTwo", root0);
        YoRegistry root1 = new YoRegistry("root");
        YoDouble variable11 = new YoDouble("variableOne", root1);
        YoDouble variable12 = new YoDouble("variableTwo", root1);
        YoVariableComparer comparer = new YoVariableComparer(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assertions.assertTrue((boolean)comparer.compare(root0, root1));
        Assertions.assertTrue((boolean)comparer.compare(variable01, variable11));
        Assertions.assertTrue((boolean)comparer.compare(variable02, variable12));
        variable01.set(4.4);
        Assertions.assertFalse((boolean)comparer.compare(root0, root1));
        Assertions.assertFalse((boolean)comparer.compare(variable01, variable11));
        Assertions.assertTrue((boolean)comparer.compare(variable02, variable12));
        variable11.set(4.4);
        Assertions.assertTrue((boolean)comparer.compare(root0, root1));
        Assertions.assertTrue((boolean)comparer.compare(variable01, variable11));
        Assertions.assertTrue((boolean)comparer.compare(variable02, variable12));
        variable02.set(99.9);
        Assertions.assertTrue((boolean)comparer.compare(variable01, variable11));
        Assertions.assertFalse((boolean)comparer.compare(variable02, variable12));
        Assertions.assertFalse((boolean)comparer.compare(root0, root1));
        variable12.set(99.9);
        Assertions.assertTrue((boolean)comparer.compare(variable01, variable11));
        Assertions.assertTrue((boolean)comparer.compare(variable02, variable12));
        Assertions.assertTrue((boolean)comparer.compare(root0, root1));
    }

    private void createVariableChangeListeners(int numberOfListeners) {
        for (int i = 0; i < numberOfListeners; ++i) {
            TestVariableChangedListener listener = new TestVariableChangedListener();
            this.variableChangedListeners.add(listener);
        }
    }

    private void addAllListenersToYoVariable() {
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            this.yoVariable.addListener((YoVariableChangedListener)observer);
        }
    }

    private void resetAllObservers() {
        for (TestVariableChangedListener observer : this.variableChangedListeners) {
            observer.reset();
        }
    }

    private static enum FooEnum {
        ONE,
        TWO,
        THREE;

    }

    private class TestVariableChangedListener
    implements YoVariableChangedListener {
        private YoVariable lastVariableChanged = null;

        private TestVariableChangedListener() {
        }

        public void changed(YoVariable v) {
            this.lastVariableChanged = v;
        }

        public YoVariable getLastVariableChanged() {
            return this.lastVariableChanged;
        }

        public void reset() {
            this.lastVariableChanged = null;
        }
    }

    private class YoVariableComparer {
        public YoVariableComparer(int maxDepth, int maxSize) throws NoSuchFieldException, SecurityException {
        }

        public boolean compare(YoDouble variable01, YoDouble variable11) {
            return ReflectionToStringBuilder.toString((Object)variable01, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE).equals(ReflectionToStringBuilder.toString((Object)variable11, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
        }

        public boolean compare(YoRegistry root0, YoRegistry root1) {
            return ReflectionToStringBuilder.toString((Object)root0, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE).equals(ReflectionToStringBuilder.toString((Object)root1, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
        }
    }
}

