/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoIntegerTest {
    private YoRegistry registry;
    private Random random;
    private YoInteger yoInteger;
    private static final double EPSILON = 1.0E-10;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.random = new Random(1776L);
        this.yoInteger = new YoInteger("test", this.registry);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoInteger = null;
    }

    @Test
    public void testSetAndGet() {
        for (int i = 0; i < 100; ++i) {
            int value = this.random.nextInt(Integer.MAX_VALUE);
            this.yoInteger.set(value);
            Assertions.assertEquals((int)value, (int)this.yoInteger.getIntegerValue());
        }
    }

    @Test
    public void testIncrementDecrementAddSubtract() {
        int value = this.random.nextInt();
        this.yoInteger.set(value);
        this.yoInteger.increment();
        Assertions.assertEquals((int)(value + 1), (int)this.yoInteger.getIntegerValue());
        this.yoInteger.decrement();
        Assertions.assertEquals((int)value, (int)this.yoInteger.getIntegerValue());
        this.yoInteger.add(value);
        Assertions.assertEquals((int)(value * 2), (int)this.yoInteger.getIntegerValue());
        this.yoInteger.sub(value);
        Assertions.assertEquals((int)value, (int)this.yoInteger.getIntegerValue());
    }

    @Test
    public void testLargeValue() {
        int value = 0x7FFFFFFD;
        this.yoInteger.set(value);
        Assertions.assertEquals((int)value, (int)this.yoInteger.getIntegerValue());
    }

    @Test
    public void testValueEquals() {
        boolean result = this.yoInteger.valueEquals(0);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void testSetFinal() {
        Assertions.assertEquals((int)0, (int)this.yoInteger.getIntegerValue());
        this.yoInteger.set(0);
        Assertions.assertEquals((int)0, (int)this.yoInteger.getIntegerValue());
        int value = this.random.nextInt() + 1;
        this.yoInteger.set(value);
        Assertions.assertEquals((int)value, (int)this.yoInteger.getIntegerValue());
    }

    @Test
    public void testSetValueFromDouble() {
        double doubleValue = this.random.nextDouble();
        int intValue = (int)Math.round(doubleValue);
        boolean notifyListeners = true;
        this.yoInteger.setValueFromDouble(doubleValue, notifyListeners);
        Assertions.assertEquals((int)intValue, (int)this.yoInteger.getIntegerValue());
    }

    @Test
    public void testGetValueAsDouble() {
        int value = 15;
        Assertions.assertEquals((int)0, (int)this.yoInteger.getIntegerValue());
        this.yoInteger.set(value);
        double result = this.yoInteger.getValueAsDouble();
        Assertions.assertEquals((double)15.0, (double)result, (double)1.0E-10);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)(this.yoInteger.getName() + ": " + this.yoInteger.getIntegerValue()), (Object)this.yoInteger.toString());
    }

    @Test
    public void testGetYoVariableType() {
        Assertions.assertEquals((Object)YoVariableType.INTEGER, (Object)this.yoInteger.getType());
    }

    @Test
    public void testGetAndSetValueAsLongBits() {
        int value = 57;
        this.yoInteger.set(value);
        long result = this.yoInteger.getValueAsLongBits();
        Assertions.assertEquals((long)value, (long)result);
        long longValue = 12345L;
        boolean notifyListeners = true;
        this.yoInteger.setValueFromLongBits(longValue, notifyListeners);
        Assertions.assertEquals((long)longValue, (long)this.yoInteger.getValueAsLongBits());
    }

    @Test
    public void testDuplicate() {
        YoInteger yoInteger2 = new YoInteger("var2", "descriptionTest", this.registry);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoInteger duplicate = yoInteger2.duplicate(newRegistry);
        Assertions.assertEquals((Object)yoInteger2.getName(), (Object)duplicate.getName());
        Assertions.assertEquals((Object)yoInteger2.getDescription(), (Object)duplicate.getDescription());
        Assertions.assertEquals((double)yoInteger2.getLowerBound(), (double)duplicate.getLowerBound(), (double)1.0E-10);
        Assertions.assertEquals((double)yoInteger2.getUpperBound(), (double)duplicate.getUpperBound(), (double)1.0E-10);
    }

    @Test
    public void testProviderValue() {
        this.yoInteger.set(1250948);
        Assertions.assertEquals((int)this.yoInteger.getIntegerValue(), (int)this.yoInteger.getValue());
        this.yoInteger.set(-521);
        Assertions.assertEquals((int)this.yoInteger.getIntegerValue(), (int)this.yoInteger.getValue());
    }
}

