/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableHolderImplementationNewTest {
    private YoVariableList yoVariableHolderImplementation;
    private ArrayList<YoVariable> testVariables;

    @BeforeEach
    public void setUp() {
        this.yoVariableHolderImplementation = new YoVariableList("Blop");
        this.testVariables = new ArrayList();
        this.testVariables.add((YoVariable)new YoDouble("yoDouble", null));
        this.testVariables.add((YoVariable)new YoBoolean("yoBoolean", null));
        this.testVariables.add((YoVariable)new YoInteger("yoInteger", null));
        this.testVariables.add((YoVariable)new YoEnum("yoEnum", null, EnumYoVariableTestEnums.class));
    }

    @AfterEach
    public void tearDown() {
        this.yoVariableHolderImplementation = null;
        this.testVariables = null;
    }

    @Test
    public void testAddSingleYoVariableToHolderAndGetVariableByName() {
        YoDouble yoDoubleFromArrayList = (YoDouble)this.testVariables.get(0);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleFromArrayList);
        Assertions.assertEquals((Object)yoDoubleFromArrayList, (Object)this.yoVariableHolderImplementation.findVariable("yoDouble"));
    }

    @Test
    public void testAddMultipleYoVariablesToHolderAndGetAllVariables() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
        for (YoVariable var : this.yoVariableHolderImplementation.getVariables()) {
            Assertions.assertTrue((boolean)this.testVariables.contains(var));
        }
    }

    @Test
    public void testGetVariableUsingFullNamespace() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
        Assertions.assertTrue((this.testVariables.get(0) == this.yoVariableHolderImplementation.findVariable("yoDouble") ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariable() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
        Assertions.assertTrue((this.testVariables.get(0) == this.yoVariableHolderImplementation.findVariable("yoDouble") ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariableCaseInsensitive() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
        YoVariable variable = this.yoVariableHolderImplementation.findVariable("YODouble");
        Assertions.assertTrue((this.testVariables.get(0) == variable ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariableWithNamespace() {
        YoRegistry testRegistry = new YoRegistry("testRegistry");
        YoDouble yoDoubleWithNamespace = new YoDouble("yoDoubleWithNamespace", testRegistry);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace);
        Assertions.assertEquals((Object)yoDoubleWithNamespace, (Object)this.yoVariableHolderImplementation.findVariable("testRegistry", "yoDoubleWithNamespace"));
    }

    @Test
    public void testGetVariableWithNamespaceCaseInsensitiveExceptNamespace() {
        YoRegistry testRegistry = new YoRegistry("testRegistry");
        YoDouble yoDoubleWithNamespace = new YoDouble("yoDoubleWithNamespace", testRegistry);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace);
        Assertions.assertEquals((Object)yoDoubleWithNamespace, (Object)this.yoVariableHolderImplementation.findVariable("testRegistry", "yoDOUBLEWithNamespace"));
        Assertions.assertNull((Object)this.yoVariableHolderImplementation.findVariable("TESTRegistry", "yoDoubleWithNamespace"));
    }

    @Test
    public void testHasUniqueVariable() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("yoDouble"));
        Assertions.assertFalse((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("yoDoubleNotPresent"));
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("yoBoolean"));
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("yoInteger"));
        Assertions.assertFalse((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("yoIntegerNotPresent"));
    }

    @Test
    public void testHasUniqueVariableWithNamespace() {
        YoRegistry testRegistry1 = new YoRegistry("testRegistry1");
        YoRegistry testRegistry2 = new YoRegistry("testRegistry2");
        YoDouble yoDoubleWithNamespace1 = new YoDouble("yoDoubleWithNamespace1", testRegistry1);
        YoDouble yoDoubleWithNamespace2 = new YoDouble("yoDoubleWithNamespace2", testRegistry2);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace1);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace2);
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("testRegistry1", "yoDoubleWithNamespace1"));
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("testRegistry2", "yoDoubleWithNamespace2"));
        Assertions.assertFalse((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("testRegistry1", "yoDoubleWithNamespace2"));
        Assertions.assertFalse((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("testRegistry2", "yoDoubleWithNamespace1"));
    }

    @Test
    public void testGetVariablesArrayList() {
        this.yoVariableHolderImplementation.addAll(this.testVariables);
    }

    @Test
    public void testGetVariablesInNamespace() {
        YoRegistry testRegistry1 = new YoRegistry("testRegistry1");
        YoRegistry testRegistry2 = new YoRegistry("testRegistry2");
        YoDouble yoDoubleWithNamespace1 = new YoDouble("yoDoubleWithNamespace1", testRegistry1);
        YoDouble yoDoubleWithNamespace2 = new YoDouble("yoDoubleWithNamespace2", testRegistry2);
        YoBoolean yoBooleanWithNamespace1 = new YoBoolean("yoBooleanWithNamespace1", testRegistry1);
        YoBoolean yoBooleanWithNamespace2 = new YoBoolean("yoBooleanWithNamespace2", testRegistry2);
        YoInteger yoIntegerWithNamespace1 = new YoInteger("yoIntegerWithNamespace1", testRegistry1);
        YoInteger yoIntegerWithNamespace2 = new YoInteger("yoIntegerWithNamespace2", testRegistry2);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace1);
        this.yoVariableHolderImplementation.add((YoVariable)yoDoubleWithNamespace2);
        this.yoVariableHolderImplementation.add((YoVariable)yoBooleanWithNamespace1);
        this.yoVariableHolderImplementation.add((YoVariable)yoBooleanWithNamespace2);
        this.yoVariableHolderImplementation.add((YoVariable)yoIntegerWithNamespace1);
        this.yoVariableHolderImplementation.add((YoVariable)yoIntegerWithNamespace2);
        ArrayList<Object> expectedArrayListFromNamespaceTestRegistry1 = new ArrayList<Object>();
        expectedArrayListFromNamespaceTestRegistry1.add(yoDoubleWithNamespace1);
        expectedArrayListFromNamespaceTestRegistry1.add(yoBooleanWithNamespace1);
        expectedArrayListFromNamespaceTestRegistry1.add(yoIntegerWithNamespace1);
        for (int i = 0; i < expectedArrayListFromNamespaceTestRegistry1.size(); ++i) {
            Assertions.assertTrue((boolean)expectedArrayListFromNamespaceTestRegistry1.contains(this.yoVariableHolderImplementation.findVariables(testRegistry1.getNamespace()).get(i)));
        }
    }

    public static enum EnumYoVariableTestEnums {
        ONE,
        TWO;

    }
}

